% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Samples-methods.R
\name{plot,Data,ModelTox-method}
\alias{plot,Data,ModelTox-method}
\title{Plot of the fitted dose-tox based with a given pseudo DLE model and data without samples}
\usage{
\S4method{plot}{Data,ModelTox}(
  x,
  y,
  xlab = "Dose level",
  ylab = "Probability of DLE",
  showLegend = TRUE,
  ...
)
}
\arguments{
\item{x}{the data of \code{\linkS4class{Data}} class object}

\item{y}{the model of the \code{\linkS4class{ModelTox}} class object}

\item{xlab}{the x axis label}

\item{ylab}{the y axis label}

\item{showLegend}{should the legend be shown? (default)}

\item{\dots}{not used}
}
\value{
This returns the \code{\link[ggplot2]{ggplot}}
object for the dose-DLE model plot
}
\description{
Plot of the fitted dose-tox based with a given pseudo DLE model and data without samples
}
\examples{
##plot the dose-DLE curve given a pseudo DLE model using data without samples
##data must be of 'Data' class 
##define the data 
data<-Data(x=c(25,50,50,75,100,100,225,300),y=c(0,0,0,0,1,1,1,1),
           doseGrid=seq(25,300,25))
##model must be from 'ModelTox' class e.g 'LogisticIndepBeta' class model
##define the model (see LogisticIndepBeta example)
model <-LogisticIndepBeta(binDLE=c(1.05,1.8),DLEweights=c(3,3),DLEdose=c(25,300),data=data)
## plot the dose-DLE curve
## 'x' is the data and 'y' is the model in plot
plot(x=data,y=model)
}
\keyword{methods}
