% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-class.R
\docType{class}
\name{Data-class}
\alias{Data-class}
\alias{.Data}
\title{Class for the data input}
\description{
This class inherits from \code{\linkS4class{GeneralData}}.
}
\section{Slots}{

\describe{
\item{\code{x}}{the doses for the patients}

\item{\code{y}}{the vector of toxicity events (0 or 1 integers)}

\item{\code{doseGrid}}{the vector of all possible doses (sorted), i.e. the dose
grid}

\item{\code{nGrid}}{number of gridpoints}

\item{\code{xLevel}}{the levels for the doses the patients have been given}

\item{\code{placebo}}{logical value: if TRUE the first dose level in the grid is
considered as PLACEBO}
}}

\examples{
# create some data from the class 'Data'
myData <- Data(x=c(0.1,0.5,1.5,3,6,10,10,10),
               y=c(0,0,0,0,0,0,1,0),
               doseGrid=c(0.1,0.5,1.5,3,6,
                          seq(from=10,to=80,by=2)))
}
\keyword{classes}
