% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_schedule.R
\name{sch_validate}
\alias{sch_validate}
\title{Validate Schedule}
\usage{
sch_validate(sch)
}
\arguments{
\item{sch}{A schedule object.}
}
\value{
A list object with a description of all error.
}
\description{
Validate your schedule in terms of structure: cannot have duplicated activity
id, all 'from' and 'to' relation id must exist in activities tibble
and cannot have duplicated relation. This function is called by
\code{sch_plan(plan)}. If there is an error, the  schedule cannot be calculated.
}
\details{
There are two forms to use this function:
\itemize{
\item The first is automatic, when you call \code{sch_plan(plan)}, the validation is
called for you.
\item The second, you can call \code{sch_plan(plan)} with your schedule, before plan,
to see all error in your schedule.
}

In both way, the calculation schedule is stopped, because there is some error.
To see the errors, you call the \code{sch_plan(plan)} function to find how to
correct the errors.

The result of \code{sch_plan(plan)} is a lista with a lot of information about the
error. The structure is:
\itemize{
\item \code{is_valid}: A logical value that indicates if the schedule structure is valid.
\itemize{
\item \code{TRUE}: The schedule structure is NOT valid.
\item \code{FALSE}: The schedule structure is valid.
}
\item \code{is_error_with_activities}: A logical value that indicates if there is
any error  with activities.
\itemize{
\item \code{TRUE}: There is any error with activities.
\item \code{FALSE}: There is NOT any error with activities.
}
\item \code{is_error_with_relations}:  A logical value that indicates if there is
any error  with relations.
\itemize{
\item \code{TRUE}: There is any error with relations.
\item \code{FALSE}: There is NOT any error with relations.
}
\item \code{is_error_with_dag}: A logical value that indicates if there is any error
with \code{igraph} object tha support the schedule.
\itemize{
\item \code{TRUE}: There is any error with igraph.
\item \code{FALSE}: There is NOT any error with igraph.
}
\item \code{activities_errors}: A tibble that list the activities errors:
\itemize{
\item \code{id}: activity's id of the error
\itemize{
\item \code{error}: the error.
\item \code{to_fix}: suggestion of how to fix the error.
}
}
\item \code{relations_errors}:
\itemize{
\item \code{from}: Predecessor activity id 'from' of the error.
\itemize{
\item \code{to}: Successor activity id from a relation.
\item \code{error}: the error.
\item \code{to_fix}: suggestion of how to fix the error.
}
}
\item \code{dag_errors}: Error identified by \code{igraph} object.
\item \code{dag_igraph}: The \code{igraph} object that is totally validated.
}

\strong{Attention:} You must identify and correct all errors
before call \code{sch_plan(plan)}!
}
\seealso{
\code{\link[=sch_add_relation]{sch_add_relation()}}, \code{\link[=sch_relations]{sch_relations()}}, \code{\link[=sch_add_relations]{sch_add_relations()}},
\code{\link[=sch_add_activities]{sch_add_activities()}}, \code{\link[=sch_add_activity]{sch_add_activity()}}, \code{\link[=sch_activities]{sch_activities()}},
\code{\link[=sch_plan]{sch_plan()}}.
}
