% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/seriesIDFunctions.R
\name{seriesID}
\alias{seriesID}
\title{Crime series identification}
\usage{
seriesID(crime, solved, seriesData, varnames, estimateBF,
  linkage.method = c("average", "single", "complete"), group.method = 3,
  ...)
}
\arguments{
\item{crime}{crime incident; vector of crime variables}

\item{solved}{incident data for the solved crimes}

\item{seriesData}{table of crimeIDs and crimeseries (results from \code{\link{makeSeriesData}})}

\item{varnames}{the variable names necessary for getting evidence variables}

\item{estimateBF}{function to estimate the bayes factor from evidence variables}

\item{linkage.method}{the type of linkage for comparing one crime to a set of crimes
  \itemize{
    \item \dQuote{average} uses the average bayes factor
    \item \dQuote{single} uses the largest bayes factor (most similar)
    \item \dQuote{complete} uses the smallest bayes factor (least similar)
  }}

\item{group.method}{the type of crime groups to form (see \code{\link{makeGroups}}
  for details)}

\item{\ldots}{other arguments passed to \code{\link{compareCrimes}}}
}
\value{
A list with two objects. \code{score} is a data.frame of the similarity
   scores for each element in \code{solved}. \code{groups} is the data.frame
   \code{seriesData} with an additional column indicating the crime group
   (using the method specified in \code{group.method}).
}
\description{
Performs crime series identification by finding the crime series that are
 most closely related (as measured by Bayes Factor) to an unsolved crime.
}
\examples{
# See vignette: "Crime Series Identification and Clustering" for usage.
}
\references{
Porter, M. D. (2014). A Statistical Approach to Crime Linkage.
   \emph{arXiv preprint arXiv:1410.2285.}.
 \url{http://arxiv.org/abs/1410.2285}
}

