% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_wait.R
\name{crew_wait}
\alias{crew_wait}
\title{Wait for an event.}
\usage{
crew_wait(
  fun,
  args = list(),
  seconds_interval = 1,
  seconds_timeout = 60,
  message = character(0)
)
}
\arguments{
\item{fun}{Function that returns \code{FALSE} to keep waiting
or \code{TRUE} to stop waiting.}

\item{args}{A named list of arguments to \code{fun}.}

\item{seconds_interval}{Nonnegative numeric of length 1,
number of seconds to wait between calls to \code{fun}.}

\item{seconds_timeout}{Nonnegative numeric of length 1,
number of seconds to loop before timing out.}

\item{message}{Character of length 1, optional error message
if the wait times out.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Repeatedly run a function while it keeps returning \code{FALSE}
and exit the loop when it returns \code{TRUE}
}
\examples{
crew_wait(fun = function() TRUE)
}
\seealso{
Other utilities: 
\code{\link{crew_eval}()},
\code{\link{crew_worker}()}
}
\concept{utilities}
