% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher.R
\name{crew_class_launcher}
\alias{crew_class_launcher}
\title{Launcher abstract class}
\description{
\code{R6} abstract class to build other subclasses
which launch and manage workers.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
router$listen()
launcher <- crew_launcher_callr()
launcher$populate(sockets = router$sockets)
launcher$launch()
m <- mirai::mirai("result")
Sys.sleep(0.25)
m$data
router$terminate()
crew_session_terminate()
}

## ------------------------------------------------
## Method `crew_class_launcher$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
router$listen()
launcher <- crew_launcher_callr()
launcher$populate(sockets = router$sockets)
launcher$launch()
m <- mirai::mirai("result")
Sys.sleep(0.25)
m$data
router$terminate()
crew_session_terminate()
}
}
\seealso{
Other launchers: 
\code{\link{crew_class_launcher_callr}},
\code{\link{crew_launcher_callr}()},
\code{\link{crew_launcher}()}
}
\concept{launchers}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{workers}}{Data frame of worker information.}

\item{\code{name}}{Name of the launcher.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_exit}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{async_dial}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{cleanup}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_launcher-new}{\code{crew_class_launcher$new()}}
\item \href{#method-crew_class_launcher-validate}{\code{crew_class_launcher$validate()}}
\item \href{#method-crew_class_launcher-settings}{\code{crew_class_launcher$settings()}}
\item \href{#method-crew_class_launcher-populate}{\code{crew_class_launcher$populate()}}
\item \href{#method-crew_class_launcher-active}{\code{crew_class_launcher$active()}}
\item \href{#method-crew_class_launcher-launch}{\code{crew_class_launcher$launch()}}
\item \href{#method-crew_class_launcher-terminate}{\code{crew_class_launcher$terminate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-new}{}}}
\subsection{Method \code{new()}}{
Launcher constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$new(
  name = NULL,
  seconds_launch = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL,
  seconds_idle = NULL,
  seconds_wall = NULL,
  seconds_exit = NULL,
  tasks_max = NULL,
  tasks_timers = NULL,
  async_dial = NULL,
  cleanup = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher]{crew_launcher()}}.
See the \code{idletime} argument of \code{mirai::server()}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{seconds_exit}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{async_dial}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}

\item{\code{cleanup}}{See \code{\link[=crew_launcher]{crew_launcher()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the launcher.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
router$listen()
launcher <- crew_launcher_callr()
launcher$populate(sockets = router$sockets)
launcher$launch()
m <- mirai::mirai("result")
Sys.sleep(0.25)
m$data
router$terminate()
crew_session_terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-settings"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-settings}{}}}
\subsection{Method \code{settings()}}{
List of arguments for \code{mirai::server()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$settings(socket)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{socket}}{Character of length 1, websocket address of the worker
to launch.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of arguments for \code{mirai::server()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-populate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-populate}{}}}
\subsection{Method \code{populate()}}{
Populate the workers data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$populate(sockets)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sockets}}{Character vector of worker websockets.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-active"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-active}{}}}
\subsection{Method \code{active()}}{
Get the active workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$active()}\if{html}{\out{</div>}}
}

\subsection{Details}{
An active worker is a worker that should be given the chance
to run tasks. To determine if the worker is active,
\code{crew} monitors seconds past launch time, and it listens
to a special non-\code{mirai} NNG websocket that the worker
is supposed to dial into on launch.
If the worker is currently connected to the websocket,
then it is active. Otherwise, if the worker is not connected
and the startup window has expired, the worker is inactive.
Otherwise, if the worker is not connected and the startup
window has not yet expired, then the worker is active
if it has not ever connected to a websocket.
}

\subsection{Returns}{
Character vector of worker websockets.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-launch}{}}}
\subsection{Method \code{launch()}}{
Launch one or more workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$launch(sockets = character(0))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sockets}}{Sockets where the workers will dial in.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If a worker is already assigned to a socket,
the previous worker is terminated before the next
one is launched.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate one or more workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher$terminate(sockets = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sockets}}{Character vector of sockets of the workers
to terminate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
