% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_cluster.R
\name{crew_class_launcher_cluster}
\alias{crew_class_launcher_cluster}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}} Abstract cluster launcher class}
\description{
\code{R6} class to help develop specific cluster launcher plugins.
}
\details{
See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.
}
\section{Attribution}{

The template files at
\url{https://github.com/mschubert/clustermq/tree/master/inst}
informed the development of the \code{crew} launcher plugins in
\code{crew.cluster}, and we would like to thank
Michael Schubert for developing \code{clustermq} and releasing it under
the permissive Apache License 2.0.
See the \code{NOTICE} and \code{README.md} files in the \code{crew.cluster}
source code for additional attribution.
}

\seealso{
Other launchers: 
\code{\link{crew_class_launcher_lsf}},
\code{\link{crew_class_launcher_pbs}},
\code{\link{crew_class_launcher_sge}},
\code{\link{crew_class_launcher_slurm}},
\code{\link{crew_launcher_cluster}()},
\code{\link{crew_launcher_lsf}()},
\code{\link{crew_launcher_pbs}()},
\code{\link{crew_launcher_sge}()},
\code{\link{crew_launcher_slurm}()}
}
\concept{launchers}
\section{Super class}{
\code{\link[crew:crew_class_launcher]{crew::crew_class_launcher}} -> \code{crew_class_launcher_cluster}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{verbose}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{command_submit}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{command_delete}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{script_directory}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{script_lines}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{prefix}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_launcher_cluster-new}{\code{crew_class_launcher_cluster$new()}}
\item \href{#method-crew_class_launcher_cluster-validate}{\code{crew_class_launcher_cluster$validate()}}
\item \href{#method-crew_class_launcher_cluster-launch_worker}{\code{crew_class_launcher_cluster$launch_worker()}}
\item \href{#method-crew_class_launcher_cluster-terminate_worker}{\code{crew_class_launcher_cluster$terminate_worker()}}
\item \href{#method-crew_class_launcher_cluster-args_launch}{\code{crew_class_launcher_cluster$args_launch()}}
\item \href{#method-crew_class_launcher_cluster-args_terminate}{\code{crew_class_launcher_cluster$args_terminate()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="call"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-call'><code>crew::crew_class_launcher$call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="expected"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-expected'><code>crew::crew_class_launcher$expected()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="launch"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-launch'><code>crew::crew_class_launcher$launch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="launching"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-launching'><code>crew::crew_class_launcher$launching()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="settings"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-settings'><code>crew::crew_class_launcher$settings()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="start"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-start'><code>crew::crew_class_launcher$start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="terminate"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-terminate'><code>crew::crew_class_launcher$terminate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_cluster-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_cluster-new}{}}}
\subsection{Method \code{new()}}{
Abstract launcher constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_cluster$new(
  name = NULL,
  seconds_launch = NULL,
  seconds_idle = NULL,
  seconds_wall = NULL,
  seconds_exit = NULL,
  tasks_max = NULL,
  tasks_timers = NULL,
  reset_globals = NULL,
  reset_packages = NULL,
  reset_options = NULL,
  garbage_collection = NULL,
  verbose = NULL,
  command_submit = NULL,
  command_delete = NULL,
  script_directory = NULL,
  script_lines = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{seconds_exit}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{reset_globals}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{reset_packages}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{reset_options}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{garbage_collection}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{verbose}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{command_submit}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{command_delete}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{script_directory}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}

\item{\code{script_lines}}{See \code{\link[=crew_launcher_cluster]{crew_launcher_cluster()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An abstract launcher object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_cluster-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_cluster-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_cluster$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly). Throws an error if a field is invalid.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_cluster-launch_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_cluster-launch_worker}{}}}
\subsection{Method \code{launch_worker()}}{
Launch a local process worker which will
dial into a socket.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_cluster$launch_worker(call, launcher, worker, instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{call}}{Text string with a namespaced call to \code{\link[=crew_worker]{crew_worker()}}
which will run in the worker and accept tasks.}

\item{\code{launcher}}{Character of length 1, name of the launcher.}

\item{\code{worker}}{Positive integer of length 1, index of the worker.
This worker index remains the same even when the current instance
of the worker exits and a new instance launches.
It is always between 1 and the maximum number of concurrent workers.}

\item{\code{instance}}{Character of length 1 to uniquely identify
the current instance of the worker.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{call} argument is R code that will run to
initiate the worker. Together, the \code{launcher}, \code{worker},
and \code{instance} arguments are useful for
constructing informative job names.
}

\subsection{Returns}{
A handle object to allow the termination of the worker
later on.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_cluster-terminate_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_cluster-terminate_worker}{}}}
\subsection{Method \code{terminate_worker()}}{
Terminate a local process worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_cluster$terminate_worker(handle)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handle}}{A process handle object previously
returned by \code{launch_worker()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_cluster-args_launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_cluster-args_launch}{}}}
\subsection{Method \code{args_launch()}}{
Worker launch arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_cluster$args_launch(script)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{script}}{Character of length 1, path to the job script for
the scheduler.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character vector of arguments to the command that
launches a worker.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_cluster-args_terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_cluster-args_terminate}{}}}
\subsection{Method \code{args_terminate()}}{
Worker termination arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_cluster$args_terminate(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Character of length 1, name of the job of the worker
on the scheduler.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character vector of arguments to the command that
terminates a worker.
}
}
}
