% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbRequest.R
\name{dbRequest}
\alias{dbRequest}
\title{Connect to the gbif4crest database}
\usage{
dbRequest(request, dbname = "gbif4crest_02")
}
\arguments{
\item{request}{A SQL request to be executed.}

\item{dbname}{The name of the data source database.}
}
\value{
The result of the request.
}
\description{
Connect to the gbif4crest_02 database by accessing the server on Amazon.
}
\examples{
\dontrun{
  # Extracting the number of taxa recorded in the database
  dbRequest("SELECT count(*) FROM taxa")

  # Extracting all the taxa that have at least one occurrence in South Africa.
  southAfricaTaxa <- dbRequest(paste0(
    "SELECT DISTINCT taxa.* ",
    "FROM taxa, distrib_qdgc, geo_qdgc ",
    "WHERE taxa.taxonid=distrib_qdgc.taxonid ",
    "AND   distrib_qdgc.latitude=geo_qdgc.latitude ",
    "AND   distrib_qdgc.longitude=geo_qdgc.longitude ",
    "AND geo_qdgc.countryname='South Africa'"
  ))
  head(southAfricaTaxa)
}

}
