% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/download_FRED.R
\name{download_FRED}
\alias{download_FRED}
\title{Get Rates from FRED}
\usage{
download_FRED(start = as.Date("2004-01-01"), end = as.Date("2005-01-04"),
  currency = "JPY")
}
\arguments{
\item{start}{is the start date of the data frame we want}

\item{end}{is the end date of the data frame we want}

\item{currency}{is the three-letter currency code. As of now, it works for
  USD, EUR, and JPY. The default is JPY.}
}
\value{
a data frame that contains the rates based on the ISDA pecifications
}
\description{
\code{download_FRED} returns the deposits and swap rates for the day input,
along with the date conventions for that specific currency. The source is
FRED.
}
\examples{
\dontrun{
download_FRED(start = as.Date("2003-12-31"), end = as.Date("2005-01-04"),
              currency = "JPY")
}
}
\seealso{
\code{\link{download_markit}} \code{\link{build_rates}}
}

