% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cleansing.R
\name{low_variance_filter}
\alias{low_variance_filter}
\title{Filtering Low Variance Variables}
\usage{
low_variance_filter(
  dat,
  lvp = 0.97,
  only_NA = FALSE,
  note = FALSE,
  ex_cols = NULL
)
}
\arguments{
\item{dat}{A data frame with x and target.}

\item{lvp}{The maximum percent of unique values (including NAs).}

\item{only_NA}{Logical, only process variables which NA's rate are more than lvp.}

\item{note}{Logical.Outputs info.Default is TRUE.}

\item{ex_cols}{A list of excluded variables. Default is NULL.}
}
\value{
A data.frame
}
\description{
\code{low_variance_filter} is for removing variables with repeated values up to a certain percentage.
}
\examples{
dat = low_variance_filter(lendingclub[1:1000, ], lvp = 0.9)

}
