% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{ks_table}
\alias{ks_table}
\alias{ks_table_plot}
\alias{ks_psi_plot}
\alias{model_key_index}
\title{ks_table & plot}
\usage{
ks_table(
  train_pred,
  test_pred = NULL,
  target = NULL,
  score = NULL,
  g = 10,
  breaks = NULL,
  pos_flag = list("1", "1", "Bad", 1)
)

ks_table_plot(
  train_pred,
  test_pred,
  target = "target",
  score = "score",
  g = 10,
  plot_show = TRUE,
  g_width = 12,
  file_name = NULL,
  save_data = FALSE,
  dir_path = tempdir(),
  gtitle = NULL
)

ks_psi_plot(
  train_pred,
  test_pred,
  target = "target",
  score = "score",
  gtitle = NULL,
  plot_show = TRUE,
  g_width = 12,
  save_data = FALSE,
  breaks = NULL,
  g = 10,
  dir_path = tempdir()
)

model_key_index(tb_pred)
}
\arguments{
\item{train_pred}{A data frame of training with predicted prob or score.}

\item{test_pred}{A data frame of validation with predict prob or score.}

\item{target}{The name of target variable.}

\item{score}{The name of prob or score variable.}

\item{g}{Number of breaks for prob or score.}

\item{breaks}{Splitting points of prob or score.}

\item{pos_flag}{The value of positive class of target variable, default: "1".}

\item{plot_show}{Logical, show model performance in current graphic device. Default is FALSE.}

\item{g_width}{Width of graphs.}

\item{file_name}{The name for periodically saved data file. Default is NULL.}

\item{save_data}{Logical, save results in locally specified folder. Default is FALSE.}

\item{dir_path}{The path for periodically saved graphic files.}

\item{gtitle}{The title of the graph & The name for periodically saved graphic file. Default is "_ks_psi_table".}

\item{tb_pred}{A table generated by code{\link{ks_table}}}
}
\description{
\code{ks_table} is for generating a model performance table.
\code{ks_table_plot} is for ploting the table generated by \code{ks_table}
\code{ks_psi_plot} is for K-S & PSI distrbution ploting.
}
\examples{
sub = cv_split(UCICreditCard, k = 30)[[1]]
dat = UCICreditCard[sub,]
dat = re_name(dat, "default.payment.next.month", "target")
dat = data_cleansing(dat, target = "target", obs_id = "ID",
occur_time = "apply_date", miss_values = list("", -1))

train_test <- train_test_split(dat, split_type = "OOT", prop = 0.7,
                                occur_time = "apply_date")
dat_train = train_test$train
dat_test = train_test$test
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5", "PAY_3", "PAY_2")
Formula = as.formula(paste("target", paste(x_list, collapse = ' + '), sep = ' ~ '))
set.seed(46)
lr_model = glm(Formula, data = dat_train[, c("target", x_list)], family = binomial(logit))

dat_train$pred_LR = round(predict(lr_model, dat_train[, x_list], type = "response"), 5)
dat_test$pred_LR = round(predict(lr_model, dat_test[, x_list], type = "response"), 5)
# model evaluation
ks_psi_plot(train_pred = dat_train, test_pred = dat_test,
                            score = "pred_LR", target = "target",
                            plot_show = TRUE)
tb_pred <- ks_table_plot(train_pred = dat_train, test_pred = dat_test,
                                        score = "pred_LR", target = "target",
                                     g = 10, g_width = 13, plot_show = FALSE)
key_index = model_key_index(tb_pred)
}
