% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/string_operations.r
\name{col_substring}
\alias{col_substring}
\title{Substring(s) of an ANSI colored string}
\usage{
col_substring(text, first, last = 1000000L)
}
\arguments{
\item{text}{Character vector, potentially ANSI styled, or a vector to
coarced to character. It is recycled to the longest of \code{first}
and \code{last}.}

\item{first}{Starting index or indices, recycled to match the length
of \code{x}.}

\item{last}{Ending index or indices, recycled to match the length
of \code{x}.}
}
\value{
Character vector of the same length as \code{x}, containing
  the requested substrings. ANSI styles are retained.
}
\description{
This is the color-aware counterpart of \code{base::substring}.
It works exactly like the original, but keeps the colors in the
substrings. The ANSI escape sequences are ignored when
calculating the positions within the string.
}
\examples{
str <- paste(
  red("red"),
  "default",
  green("green")
)

cat(str, "\\n")
cat(col_substring(str, 1, 5), "\\n")
cat(col_substring(str, 1, 15), "\\n")
cat(col_substring(str, 3, 7), "\\n")

substring(strip_style(str), 1, 5)
substring(strip_style(str), 1, 15)
substring(strip_style(str), 3, 7)

str2 <- "another " \%+\%
  red("multi-", sep = "", underline("style")) \%+\%
  " text"

cat(str2, "\\n")
cat(col_substring(str2, c(3,5), c(7, 18)), sep = "\\n")
substring(strip_style(str2), c(3,5), c(7, 18))
}
\seealso{
Other ANSI string operations: \code{\link{col_nchar}};
  \code{\link{col_strsplit}}; \code{\link{col_substr}}
}

