% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcmc_mix3}
\alias{mcmc_mix3}
\title{Markov chain Monte Carlo for 3-component discrete extreme value mixture distribution}
\usage{
mcmc_mix3(
  x,
  count,
  v_set,
  u_set,
  v,
  u,
  alpha1,
  theta1,
  alpha2,
  theta2,
  shape,
  sigma,
  a_psi1,
  a_psi2,
  a_psiu,
  b_psiu,
  a_alpha1,
  b_alpha1,
  a_theta1,
  b_theta1,
  a_alpha2,
  b_alpha2,
  a_theta2,
  b_theta2,
  m_shape,
  s_shape,
  a_sigma,
  b_sigma,
  powerlaw1,
  positive1,
  positive2,
  a_pseudo,
  b_pseudo,
  pr_power2,
  iter,
  thin,
  burn,
  freq,
  invt,
  mc3_or_marg = TRUE
)
}
\arguments{
\item{x}{Vector of the unique values (positive integers) of the data}

\item{count}{Vector of the same length as x that contains the counts of each unique value in the full data, which is essentially rep(x, count)}

\item{v_set}{Positive integer vector of the values v will be sampled from}

\item{u_set}{Positive integer vector of the values u will be sampled from}

\item{v}{Positive integer, initial value of the lower threshold}

\item{u}{Positive integer, initial value of the upper threshold}

\item{alpha1}{Real number greater than 1, initial value of the parameter}

\item{theta1}{Real number in (0, 1], initial value of the parameter}

\item{alpha2}{Real number greater than 1, initial value of the parameter}

\item{theta2}{Real number in (0, 1], initial value of the parameter}

\item{shape}{Real number, initial value of the parameter}

\item{sigma}{Positive real number, initial value of the parameter}

\item{a_psi1, a_psi2, a_psiu, b_psiu, a_alpha1, b_alpha1, a_theta1, b_theta1, a_alpha2, b_alpha2, a_theta2, b_theta2, m_shape, s_shape, a_sigma, b_sigma}{Scalars, real numbers representing the hyperparameters of the prior distributions for the respective parameters. See details for the specification of the priors.}

\item{powerlaw1}{Boolean, is the discrete power law assumed for below v?}

\item{positive1}{Boolean, is alpha1 positive (TRUE) or unbounded (FALSE)?}

\item{positive2}{Boolean, is alpha2 positive (TRUE) or unbounded (FALSE)?}

\item{a_pseudo}{Positive real number, first parameter of the pseudoprior beta distribution for theta2 in model selection; ignored if pr_power2 = 1.0}

\item{b_pseudo}{Positive real number, second parameter of the pseudoprior beta distribution for theta2 in model selection; ignored if pr_power2 = 1.0}

\item{pr_power2}{Real number in [0, 1], prior probability of the discrete power law (between v and u)}

\item{iter}{Positive integer representing the length of the MCMC output}

\item{thin}{Positive integer representing the thinning in the MCMC}

\item{burn}{Non-negative integer representing the burn-in of the MCMC}

\item{freq}{Positive integer representing the frequency of the sampled values being printed}

\item{invt}{Vector of the inverse temperatures for Metropolis-coupled MCMC}

\item{mc3_or_marg}{Boolean, is invt for parallel tempering / Metropolis-coupled MCMC (TRUE, default) or marginal likelihood via power posterior (FALSE)?}
}
\value{
A list: $pars is a data frame of iter rows of the MCMC samples, $fitted is a data frame of length(x) rows with the fitted values, amongst other quantities related to the MCMC
}
\description{
\code{mcmc_mix3} returns the posterior samples of the parameters, for fitting the 3-component discrete extreme value mixture distribution. The samples are obtained using Markov chain Monte Carlo (MCMC).
}
\details{
In the MCMC, a componentwise Metropolis-Hastings algorithm is used. The thresholds v and u are treated as parameters and therefore sampled. The hyperparameters are used in the following priors: psi1 / (1.0 - psiu) ~ Beta(a_psi1, a_psi2); u is such that the implied unique exceedance probability psiu ~ Uniform(a_psi, b_psi); alpha1 ~ Normal(mean = a_alpha1, sd = b_alpha1); theta1 ~ Beta(a_theta1, b_theta1); alpha2 ~ Normal(mean = a_alpha2, sd = b_alpha2); theta2 ~ Beta(a_theta2, b_theta2); shape ~ Normal(mean = m_shape, sd = s_shape); sigma ~ Gamma(a_sigma, scale = b_sigma). If pr_power2 = 1.0, the discrete power law (between v and u) is assumed, and the samples of theta2 will be all 1.0. If pr_power2 is in (0.0, 1.0), model selection between the polylog distribution and the discrete power law will be performed within the MCMC.
}
\seealso{
\code{\link{mcmc_pol}} and \code{\link{mcmc_mix2}} for MCMC for the Zipf-polylog and 2-component discrete extreme value mixture distributions, respectively.
}
