% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matrix_rank}
\alias{matrix_rank}
\title{Rank of a Matrix}
\usage{
matrix_rank(x)
}
\arguments{
\item{x}{a numeric matrix}
}
\value{
the rank of the matrix as a numeric value.
}
\description{
Determine the rank (number of linearly independent columns) of a matrix.
}
\details{
Implimentation via the Armadillo C++ linear algrebra library.  The function
returns the rank of the matix \code{x}.  The computation is based on the
singular value decomposition of the matrix; a std::runtime_error excetion
will be thrown if the decomposition fails.  Any singular values less than
the tolerance are treated as zeros.  The tolerance is max(m, n) * max_sv *
datum::eps, where m is the number of rows of x, n is the number of columns
of x, max_sv is the maximal singular value of x, and datum::eps is the
difference between 1 and the least value greater than 1 that is
representable.
}
\examples{
# Check the rank of a matrix
mat <- matrix(rnorm(25000 * 120), nrow = 25000)
Matrix::rankMatrix(mat)[1]
matrix_rank(mat)

# A full rank B-spline basis
bmat <- bsplines(seq(0, 1, length = 100), df = 15)
matrix_rank(bmat)

# A rank deficient B-spline basis
bmat <- bsplines(seq(0, 1, length = 100), iknots = c(0.001, 0.002))
ncol(bmat)
matrix_rank(bmat)

}
\references{
Conrad Sanderson and Ryan Curtin.  Armadillo: a template-based C++ library
for linear algebra.  Journal of Open Source Software, Vol. 1, pp. 26, 2016.
}
\author{
Peter DeWitt \email{dewittpe@gmail.com}
}
