% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_distance_pair.R
\name{get_distance_pair}
\alias{get_distance_pair}
\title{Compute shortest distance between origin and destination nodes.}
\usage{
get_distance_pair(Graph, from, to, algorithm = "bi", constant = 1,
  allcores = FALSE)
}
\arguments{
\item{Graph}{An object generated by makegraph(), cpp_simplify() or cpp_contract() function.}

\item{from}{A vector of one or more vertices from which distances are calculated (origin).}

\item{to}{A vector of one or more vertices (destination).}

\item{algorithm}{character. "Dijkstra" for uni-directional Dijkstra, "bi" for bi-directional Dijkstra, "A*" for A star unidirectional search or "NBA" for New bi-directional A star .Default to "Dijkstra"}

\item{constant}{numeric. Constant to maintain the heuristic function admissible in A* and NBA algorithms. 
Default to 1, when cost is expressed in the same unit than coordinates. See details}

\item{allcores}{Logical. If TRUE, all cores are used.}
}
\value{
Vector of shortest distances.
}
\description{
Compute shortest distance between origin and destination nodes.
}
\details{
If graph is not contracted, the user has the choice between : \itemize{
  \item unidirectional Dijkstra (Dijkstra) 
  \item A star (A*) : projected coordinates should be provided
  \item bidirectional Dijkstra (bi)
  \item New bi-directional A star (NBA) : projected coordinates should be provided
}

If the input graph has been contracted by cpp_contract() function, the algorithm is a modified bidirectional search.  
  
In A* and New Bidirectional A star algorithms, euclidean distance is used as heuristic function.
To understand how A star algorithm work, see \url{https://en.wikipedia.org/wiki/A*_search_algorithm}.
To understand the importance of constant parameter, see the package description : \url{https://github.com/vlarmet/cppRouting/blob/master/README.md}
}
\note{
'from' and 'to' must be the same length.
}
\examples{
#Data describing edges of the graph
edges<-data.frame(from_vertex=c(0,0,1,1,2,2,3,4,4), 
                  to_vertex=c(1,3,2,4,4,5,1,3,5), 
                  cost=c(9,2,11,3,5,12,4,1,6))

#Get all nodes
nodes<-unique(c(edges$from_vertex,edges$to_vertex))
 
#Construct directed and undirected graph 
directed_graph<-makegraph(edges,directed=TRUE)
non_directed<-makegraph(edges,directed=FALSE)

#Sampling origin and destination nodes
origin<-sample(nodes,10,replace=TRUE)
destination<-sample(nodes,10,replace=TRUE)

#Get distance between origin and destination in the two graphs
dir_dist<-get_distance_pair(Graph=directed_graph, from=origin, to=destination, allcores=FALSE)
non_dir_dist<-get_distance_pair(Graph=non_directed, from=origin, to=destination, allcores=FALSE)
print(dir_dist)
print(non_dir_dist)
}
