% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/positividad.R
\name{positividad}
\alias{positividad}
\title{Positividad}
\usage{
positividad(
  datos_covid,
  entidades = c("AGUASCALIENTES", "BAJA CALIFORNIA", "BAJA CALIFORNIA SUR", "CAMPECHE",
    "CHIAPAS", "CHIHUAHUA", "CIUDAD DE MÉXICO", "COAHUILA DE ZARAGOZA", "COLIMA",
    "DURANGO", "GUANAJUATO", "GUERRERO", "HIDALGO", "JALISCO", "MÉXICO",
    "MICHOACÁN DE OCAMPO", "MORELOS", "NAYARIT", "NUEVO LEÓN", "OAXACA", "PUEBLA",
    "QUERÉTARO", "QUINTANA ROO", "SAN LUIS POTOSÍ", "SINALOA", "SONORA", "TABASCO",
    "TAMAULIPAS", "TLAXCALA", "VERACRUZ DE IGNACIO DE LA LLAVE", "YUCATÁN", "ZACATECAS"),
  group_by_entidad = TRUE,
  entidad_tipo = c("Unidad Medica", "Residencia", "Nacimiento"),
  fecha_tipo = c("Sintomas", "Ingreso", "Defuncion"),
  tipo_prueba = c("Antigeno", "PCR"),
  group_by_tipo_prueba = TRUE,
  tipo_paciente = c("AMBULATORIO", "HOSPITALIZADO", "NO ESPECIFICADO"),
  group_by_tipo_paciente = FALSE,
  tipo_uci = c("SI", "NO", "NO APLICA", "SE IGNORA", "NO ESPECIFICADO"),
  group_by_tipo_uci = FALSE,
  tipo_sector = c("CRUZ ROJA", "DIF", "ESTATAL", "IMSS", "IMSS-BIENESTAR", "ISSSTE",
    "MUNICIPAL", "PEMEX", "PRIVADA", "SEDENA", "SEMAR", "SSA", "UNIVERSITARIO",
    "NO ESPECIFICADO"),
  group_by_tipo_sector = FALSE,
  defunciones = FALSE,
  edad_cut = NULL,
  fill_NA = TRUE,
  list_name = "positividad",
  remove_inconclusive = TRUE,
  .grouping_vars = c()
)
}
\arguments{
\item{datos_covid}{(\strong{obligatorio}) Lista de \code{tibble}s o \code{duckdb}s resultante de
\code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} o \code{\link[=read_datos_abiertos]{read_datos_abiertos()}}}

\item{entidades}{(\strong{opcional})  Vector con las entidades de las unidades medicas a analizar.
Opciones: \code{AGUASCALIENTES}, \verb{BAJA CALIFORNIA}, \verb{BAJA CALIFORNIA SUR},
\code{CAMPECHE}, \code{CHIAPAS}, \code{CHIHUAHUA}, \verb{CIUDAD DE MEXICO},
\verb{COAHUILA DE ZARAGOZA} , \code{COLIMA}, \code{DURANGO}, \code{GUANAJUATO}, \code{GUERRERO},
\code{HIDALGO}, \code{JALISCO}, \code{MEXICO}, \verb{MICHOACAN DE OCAMPO}, \code{MORELOS},\code{NAYARIT}
\verb{NUEVO LEON}, \code{OAXACA} ,\code{PUEBLA}, \code{QUERETARO},\verb{QUINTANA ROO},
\verb{SAN LUIS POTOSI}, \code{SINALOA}, \code{SONORA}, \code{TABASCO}, \code{TAMAULIPAS},\code{TLAXCALA},
\verb{VERACRUZ DE IGNACIO DE LA LLAVE}, \code{YUCATAN}, \code{ZACATECAS}.}

\item{group_by_entidad}{(\strong{opcional}) \code{TRUE} obtiene los casos para cada entidad reportando
en cada fecha la entidad y los casos en dicha entidad. \code{FALSE}  junta las \code{entidades} sumando
sus casos en una sola observacion por cada fecha.}

\item{entidad_tipo}{(\strong{opcional}) Indica a que se refiere las \code{entidades} seleccionadas. Elige
una de las opciones: \verb{Unidad Medica} (entidad de la unidad medica), \code{Nacimiento}
(entidad de origen del individuo) o \code{Residencia} (entidad donde reside el individuo).}

\item{fecha_tipo}{(\strong{opcional}) Selecciona si la fecha que se utiliza es la fecha de \code{Ingreso}
(si aplica), la fecha de \code{Sintomas} o la de \code{Defuncion} (si aplica). El default es fecha de \code{Sintomas}.}

\item{tipo_prueba}{(\strong{opcional}) Vector con el tipo de pruebas a incluir \code{Antigeno}, \code{PCR}. Por
default se incluyen ambas.}

\item{group_by_tipo_prueba}{(\strong{opcional}) Booleana determinando si regresa la base
con cada entrada agrupada por \code{tipo_prueba}. En caso \code{TRUE} (cada fecha
y entidad reporta separado el los casos de PCR y Antigeno). En caso \code{FALSE} se juntan
los casos de PCR y Antigeno para devolver un unico numero por fecha.}

\item{tipo_paciente}{(\strong{opcional}) Vector con el tipo de pacientes a incluir. Opciones:
\code{AMBULATORIO}, \code{HOSPITALIZADO}, \verb{NO ESPECIFICADO}. Por default se incluyen todos.}

\item{group_by_tipo_paciente}{(\strong{opcional}) Booleana determinando (caso \code{TRUE}) si regresa
la base con cada entrada agrupada por \code{tipo_paciente} (es decir cada fecha
se genera un renglon para \code{AMBULATORIO}, un renglon para \code{HOSPITALIZADO}, etc) o bien
si se suman todos los grupos y cada fecha reporta solo la suma de estos
(estilo \code{AMBULATORIO + HOSPITALIZADO} segun las categorias de \code{tipo_paciente})
El default es \code{FALSE}.}

\item{tipo_uci}{(\strong{opcional})  Vector con el tipo de valores para Unidad de
Cuidado Intensivo (UCI) a incluir:  \code{SI},\code{NO},\verb{NO APLICA},\verb{SE IGNORA},\verb{NO ESPECIFICADO}.
Por default se incluyen todos.}

\item{group_by_tipo_uci}{(\strong{opcional}) Booleana. El caso \code{TRUE} determina si regresa la base
con cada fecha teniendo diferentes renglones uno para cada \code{tipo_uci} (es decir cada fecha
se generan tantos observaciones como grupos de tipo de UCI) o bien en una sola fecha
se suman todos los tipos de UCI (\code{FALSE}). El default es \code{FALSE}.}

\item{tipo_sector}{(\strong{opcional}) Vector con los sectores del sistema de salud a incluir:
\verb{CRUZ ROJA},\code{DIF},\code{ESTATAL},\code{IMSS},\code{IMSS-BIENESTAR},\code{ISSSTE}, \code{MUNICIPAL},\code{PEMEX},
\code{PRIVADA},\code{SEDENA},\code{SEMAR},\code{SSA}, \code{UNIVERSITARIO},\verb{NO ESPECIFICADO}.
Por default se incluyen todos.}

\item{group_by_tipo_sector}{(\strong{opcional}) Booleana determina en el caso de \code{TRUE} si regresa
la base con cada entrada agrupada por \code{tipo_sector} (es decir cada fecha
tiene una entrada con los del \code{IMSS}, una entrada distinta con los de \code{ISSSTE}, etc) o bien
en caso de \code{FALSE} se devuelve una sola entrada por fecha con la suma \code{IMSS + ISSSTE + etc}
segun los  sectores seleccionados. El default es \code{FALSE}.}

\item{defunciones}{(\strong{opcional})  Booleana si incluir sólo defunciones \code{TRUE} o a todos \code{FALSE}.
El default es \code{FALSE}.}

\item{edad_cut}{(\strong{opcional}) Vector con secuencia de edades para hacer grupos. Por ejemplo
\code{edad_cut = c(0, 10, Inf)} arma dos grupos de edad de 0 a 10 y de 10 a infinito o bien
\code{edad_cut = c(15, 20)} deja sólo los registros entre 15 y 20 años. Por default es \code{NULL}
y no arma grupos etarios.}

\item{fill_NA}{(\strong{opcional})  Regresa observaciones para todas las combinaciones de variables
incluyendo como \code{NA} donde no se observaron casos en el denominador.  En caso contrario no se
incluyen las filas donde no se observaron casos.}

\item{list_name}{(\strong{opcional}) Asigna un nombre en la lista de datos a la base generada}

\item{remove_inconclusive}{(\strong{opcional})  Si \code{TRUE} no considera en el denominador de la
positividad las pruebas cuyo resultado es inconcluso o aún no ha sido otorgado. Si \code{FALSE}
considera a todos. Por default es \code{TRUE}.}

\item{.grouping_vars}{(\strong{opcional}) Vector de variables adicionales de agrupacion de los
conteos. Por ejemplo si se agrega \code{.grouping_vars = 'DIABETES'} entonces para cada fecha habra
dos conteos de casos uno de los que tienen diabetes y uno de los que no.}
}
\value{
Une a la lista de \code{datos_covid} una nueva entrada de nombre \code{list_name}
(default: \code{positividad}) con una base de datos (\code{tibble}) con los
resultados agregados.
\itemize{
\item positividad - Base de datos generara con los datos agregados (el nombre cambia si
se usa \code{list_name}).
\item dict - Diccionario de datos
\item dats - Datos originales (conexion a \code{duckdb} o \code{tibble})
\item disconnect  - Función para desconectarte de \code{duckdb}
\item ... - Cualquier otro elemento que ya existiera en \code{datos_covid}
}
}
\description{
\code{positividad} Calcula la positividad  por fecha agrupando (o sin hacerlo)
por covariables. Por default calcula la positividad de las pruebas
haciendo Antigeno y PCR por separado, cada una por fecha y entidad.
}
\details{
La positividad se define como
\deqn{\frac{\# Pruebas positivas}{Total de pruebas}}{%
\# Pruebas positivas / Total de pruebas}
Si se utiliza la opción \code{remove_inconclusive = TRUE} el \strong{Total de pruebas} se calcula
utilizando solo \code{POSITIVOS + NEGATIVOS}. Si \code{remove_inconclusive = FALSE} se calcula
utilizando todas las personas que tuvieron prueba:
\verb{POSITIVOS + NEGATIVOS + INCONCLUSOS + SIN RESULTADO}.

Si no se realizaron pruebas un dia la positividad no esta definida pues el \strong{Total de pruebas}
es cero. En ese caso si \code{fill_NA = TRUE} se devuelven las entradas de esos dias pero
con valor \code{NA}.
}
\examples{

# Para el ejemplo usaremos los datos precargados (datosabiertos) pero tu puedes
# correr el ejemplo descargando informacion mas reciente.
datos_covid <- datosabiertos

# Casos a nivel nacional por estado por tipo de prueba
datos_covid <- datos_covid |> positividad()
head(datos_covid$positividad)

\donttest{
# Total nacional sumando todas las pruebas del pais
datos_covid <- datos_covid |>
  positividad(group_by_entidad = FALSE, list_name = "positividad_nacional")
head(datos_covid$positividad_nacional)

# Positivos en Baja California y Baja California Sur
datos_covid <- datos_covid |>
  positividad(
    entidades = c("BAJA CALIFORNIA", "BAJA CALIFORNIA SUR"),
    list_name = "positividad_californiana"
  )
head(datos_covid$positividad_californiana)

# Agrupando ambas pruebas en una sola positividad global
datos_covid <- datos_covid |>
  positividad(
    entidades = c("BAJA CALIFORNIA", "BAJA CALIFORNIA SUR"),
    group_by_tipo_prueba = FALSE,
    list_name = "positividad_californiana_2"
  )
head(datos_covid$positividad_californiana_2)

# Regresa la suma de ambos estados pero dividiendo por tipo de paciente
datos_covid <- datos_covid |>
  positividad(
    entidades = c("BAJA CALIFORNIA", "BAJA CALIFORNIA SUR"),
    group_by_entidad = FALSE,
    tipo_paciente = c("AMBULATORIO", "HOSPITALIZADO"),
    group_by_tipo_paciente = TRUE,
    list_name = "positividad_paciente"
  )
head(datos_covid$positividad_paciente)

# Si deseas agrupar por una variable que no este en las opciones va en .grouping_vars
datos_covid <- datos_covid |>
  positividad(
    tipo_sector = "IMSS",
    .grouping_vars = c("SEXO"),
    list_name = "positividad_imss_sexo"
  )
head(datos_covid$positividad_imss_sexo)
}

# Una vez hayas concluido tu trabajo no olvides desconectar
datos_covid$disconnect()
}
\references{
Furuse, Y., Ko, Y. K., Ninomiya, K., Suzuki, M., & Oshitani, H. (2021). Relationship of test
positivity rates with COVID-19 epidemic dynamics. International journal of environmental
research and public health, 18(9), 4655.

Al Dallal, A., AlDallal, U., & Al Dallal, J. (2021). Positivity rate: an indicator for the
spread of COVID-19. Current Medical Research and Opinion, 37(12), 2067-2076.
}
\seealso{
\code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} \code{\link[=numero_pruebas]{numero_pruebas()}} \code{\link[=cfr]{cfr()}} \code{\link[=chr]{chr()}} \code{\link[=estima_rt]{estima_rt()}} \code{\link[=casos]{casos()}}
}
