% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descarga_datos_variantes_GISAID.R
\encoding{UTF-8}
\name{descarga_datos_variantes_GISAID}
\alias{descarga_datos_variantes_GISAID}
\title{Lee la base de datos de variantes de COVID-19 en Mexico generada por GISAID}
\usage{
descarga_datos_variantes_GISAID(
  nivel = c("nacional", "cdmx"),
  cache = NULL,
  use_cache_on_failure = TRUE,
  quiet = FALSE,
  force_download = FALSE,
  show_warnings = TRUE,
  ...
)
}
\arguments{
\item{nivel}{(\strong{opcional}) si se desea descargar informacion \code{"nacional"} (default) o de
la Ciudad de Mexico: \code{"cdmx"}.}

\item{cache}{(\strong{opcional}) cache para \code{\link[pins:board_url]{pins::board_url()}}. Representa el directorio donde
se almacenaran los datos descargados en formato de \code{pins}.}

\item{use_cache_on_failure}{(\strong{opcional})  parametro para \code{\link[pins:board_url]{pins::board_url()}}. En caso de
\code{TRUE} (default) si no puede descargar nueva informacion utiliza la que ya tiene en memoria
aunque sea vieja.}

\item{quiet}{(\strong{opcional}) booleana para no imprimir mensajes en la consola.}

\item{force_download}{(\strong{opcional})  analiza si cambio el pin y descarga datos nuevos en
caso afirmativo.}

\item{show_warnings}{(\strong{opcional}) si arrojar \code{warnings} o callar}

\item{...}{parametros adicionales para \code{\link[pins:pin_download]{pins::pin_download()}}.}
}
\value{
\code{tibble} con los datos de porcentuales de variantes
\itemize{
\item \code{variant}       - La variante clasificada mediante \href{https://cov-lineages.org/resources/pangolin.html}{Pangolin}
\item \code{semana}        - Semana epidemiologica \code{\link[lubridate:week]{lubridate::epiweek()}} a la que corresponde la variante
\item \code{ano}           - Anio al que corresponde la toma de muestra
\item \code{n}             - El total de muestras de dicha semana registradas para esa variante
\item \code{freq}          - La proporcion de las variantes de dicha semana ocupada por dicha variante. Se obtiene dividiendo \code{n/sum(n)} para cada semana.
\item \code{Actualizacion} - La fecha de actualizacion ultima de los datos.
\item \code{Fuente}        - La fuente desde la cual se obtuvo la informacion de dicha variante.
}
}
\description{
\code{descarga_datos_variantes_GISAID} Lee los datos de variantes del reporte nacional diario en
\href{https://github.com/RodrigoZepeda/VariantesCovid}{RodrigoZepeda/VariantesCovid}
creado a partir de la informacion de la
\href{https://gisaid.org/}{Global Initiative on Sharing Avian Influenza Data (GISAID)}
}
\details{
Cada vez que uses estos datos necesitas citar a \strong{GISAID} (ver referencias) asi como
el reporte en \href{https://github.com/RodrigoZepeda/VariantesCovid}{RodrigoZepeda/VariantesCovid}

Los datos son descargados de manera automatica en mi Github:
\href{https://github.com/RodrigoZepeda/VariantesCovid}{RodrigoZepeda/VariantesCovid} el programa
\code{descarga_datos_variantes_GISAID} se conecta a dicho repositorio, busca si la informacion esta
actualizada y si si la descarga, si no, utiliza informacion almacenada en el \code{cache} local.

La descarga usa el paquete \code{pins}
}
\examples{

# Descarga de variantes a nivel nacional
url_global <- "https://raw.githubusercontent.com/RodrigoZepeda/VariantesCovid/main/tablas/"
if (RCurl::url.exists(paste0(url_global, "Proporcion_variantes_nacional.csv"))) {
  variantes_covid <- descarga_datos_variantes_GISAID("nacional")
}

# Descarga de variantes para CDMX
if (RCurl::url.exists(paste0(url_global, "Proporcion_variantes_cdmx.csv"))) {
  variantes_covid <- descarga_datos_variantes_GISAID("cdmx")
}

}
\references{
Khare, S., et al (2021) GISAID's Role in Pandemic Response. China CDC Weekly, 3(49):
1049-1051. doi:10.46234/ccdcw2021.255 PMCID: 8668406

Elbe, S. and Buckland-Merrett, G. (2017) Data, disease and diplomacy: GISAID’s
innovative contribution to global health. Global Challenges, 1:33-46.
doi:10.1002/gch2.1018 PMCID: 31565258

Shu, Y. and McCauley, J. (2017) GISAID: from vision to reality. EuroSurveillance,
22(13) doi:10.2807/1560-7917.ES.2017.22.13.30494 PMCID: PMC5388101

Zepeda-Tello, R. (2022). Reporte Nacional de Variantes de COVID-19.
URL: \url{https://github.com/RodrigoZepeda/VariantesCovid}
}
\seealso{
\code{\link[=descarga_datos_red_irag]{descarga_datos_red_irag()}} \code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} \code{\link[=read_datos_abiertos]{read_datos_abiertos()}}
}
