% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid19sf_homeless}
\alias{covid19sf_homeless}
\title{San Francisco COVID-19 Cases Summarized by Homelessness Status}
\format{
An object class data.frame with 5 variables
\describe{
  \item{specimen_collection_date}{Date which case was recorded in YYYY-MM-DD format.}
  \item{homelessness_status}{The homelessness status, a signle category variable c("Homeless")}
  \item{new_confirmed_cases}{Total cases confirmed cases per date}
  \item{cumulative_confirmed_cases}{Cumulative confirmed cases}
  \item{last_updated}{The table last update time in POSIX format}
  }
}
\source{
San Francisco, Department of Public Health - Population Health Division through San Francisco Opne Data protal \href{https://datasf.org/opendata/}{website}.
}
\usage{
covid19sf_homeless
}
\description{
This dataset represents the COVID-19 positive confirmed cases by homelessness.
 Demographic and transmission data are based on information reported from case
 interviews, laboratories, and providers.
 This data may not be immediately available for recently reported cases
 and data will change to reflect as information becomes available.
 Cumulative counts of 5 or fewer are excluded from the dataset.
 More information about the data available \href{https://data.sfgov.org/COVID-19/COVID-19-Cases-Summarized-by-Homelessness-Status/b45x-2crv}{here}
}
\details{
The dataset contains the daily summary of covid19 cases in San Francisco by homelessness status
}
\examples{
data(covid19sf_homeless)

head(covid19sf_homeless)
}
\keyword{COVID19}
\keyword{datasets}
\keyword{homeless}
\keyword{summary}
