% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/covatree.R
\docType{class}
\name{covatree-class}
\alias{covatree}
\alias{covatree-class}
\title{A Reference Class for Search Tree Approximated Local Polynomial Regression with covatree.}
\description{
A Reference Class for Search Tree Approximated Local Polynomial Regression with covatree.
}
\section{Fields}{

\describe{
\item{\code{ptr}}{External pointer to the covatree C++ object}
}}
\section{Methods}{

\describe{
\item{\code{getDim()}}{Get the dimension of the coordinates.}

\item{\code{initialize(coord, obs, h = suggestBandwith(coord, p), p = 3L,
  minLeft = length(obs)/10, ...)}}{Method to initialize the covafill. coord is a matrix of coordinates, obs is a vector of corresponding observations, h is a vector of bandwiths, p is the polynomial degree, and minLeft is the minimum number of observations that will create a sub tree.}

\item{\code{predict(coord)}}{Predict function value and first order derivatives with search tree approximated local polynomial regression at coord.}
}}
\examples{
getRefClass('covatree')
fn <- function(x) x ^ 4 - x ^ 2
x <- runif(2000,-3,3)
y <- fn(x) + rnorm(2000,0,0.1)
ct <- covatree(coord = x,obs = y,p = 5L, minLeft = 50)
ct$getDim()
x0 <- seq(-1,1,0.1)
y0 <- ct$predict(x0)
par(mfrow=c(2,1))
plot(x0,y0[,1], main = "Function")
lines(x0,fn(x0))
plot(x0, y0[,2], main = "First derivative")
lines(x0, 4 * x0 ^ 3 - 2 * x0)
}

