% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor2.R
\name{cosinor.poptests}
\alias{cosinor.poptests}
\title{Comparison of Cosinor Parameters of Two Populations}
\usage{
cosinor.poptests(pop1, pop2)
}
\arguments{
\item{pop1}{An object of the \code{population.cosinor.lm} class calculated on the first population.}

\item{pop2}{An object of the \code{population.cosinor.lm} class calculated on the second population.}
}
\description{
Runs the tests that compare MESORs, amplitudes and acrophases of two different populations.
}
\details{
Bingham et al. (1982) describe tests for comparing population MESORs, amplitudes and acrophases. These tests are esentially F-ratios with \eqn{df_1 = m - 1} and \eqn{df_2 = K - m}, where \eqn{m} is the number of populations and \eqn{K} is the total number of subjects. The tests for MESOR, amplitude and acrophase differences respectively are calculated as follows:
\deqn{F_M = \frac{\sum_{j = 1}^{m}k_j(\widehat{M}_j - \widehat{M})^2}{(m-1)\widehat{\sigma}_M^2}}
\deqn{F_\phi = \frac{\frac{\sum_{j = 1}^{m}k_j A_j^2 * sin^2(\widehat{\phi}_j - \tilde{\phi})}{m - 1}} {\widehat{\sigma}_\beta^2 sin^2\tilde{\phi} + 2\widehat{\sigma}_{\beta \gamma} cos\tilde{\phi}sin\tilde{\phi} + \widehat{\sigma}_\gamma^2 cos^2\tilde{\phi}}}
\deqn{F_A = \frac{\frac{\sum_{j = 1}^{m}(\widehat{A}_j - \widehat{A})^2}{m - 1}}{\widehat{\sigma}^2_\beta cos^2\widehat{\phi} - 2\widehat{\sigma}_{\beta \gamma}cos\widehat{\phi}sin\widehat{\phi} + \widehat{\sigma}^2_\gamma sin^2 \widehat{\phi}}}
where \eqn{\widehat{M}}, \eqn{\widehat{A}} and \eqn{\widehat{\phi}} are weighted averages of parameters across populations calculated as:
\deqn{\widehat{M} = \frac{\sum_{j = 1}^{m}k_j\widehat{M}_j}{K}}
\deqn{\widehat{A} = \frac{\sum_{j = 1}^{m}k_j\widehat{A}_j}{K}}
\deqn{\widehat{\phi} = \frac{\sum_{j = 1}^{m}k_j\widehat{\phi}_j}{K}}
\eqn{\tilde{\phi}} is derived from the following expression:
\deqn{tan 2\tilde{\phi} = \frac{\sum_{j = 1}^{m}k_j\widehat{A}^2_j sin 2\widehat{\phi}_j}{\sum_{j = 1}^{m}k_j\widehat{A}^2_j cos 2\widehat{\phi}_j}}
where \eqn{2\tilde{\phi}} lies between \eqn{-\frac{\pi}{2}} and \eqn{\frac{\pi}{2}} if the denomanator is positive or between \eqn{\frac{\pi}{2}} and \eqn{\frac{3\pi}{2}} if the denominator is negative, \eqn{k_j} is the number of subjects in the \eqn{j}th population, \eqn{\widehat{M}_j}, \eqn{\widehat{A}_j} and \eqn{\widehat{\phi}_j} are the cosinor parameters of the \eqn{j}th population and \eqn{\widehat{\sigma}_\beta},\eqn{\widehat{\sigma}_\gamma} and \eqn{\widehat{\sigma}_{\beta \gamma}} are the estimates of pooled standard deviations (and covariance) calculated as following:
\deqn{\widehat{\sigma}_\beta = \frac{\sum_{j = 1}^{m} (k_j - 1)\widehat{\sigma}_{\beta_j}}{K - m}}
\deqn{\widehat{\sigma}_\gamma = \frac{\sum_{j = 1}^{m} (k_j - 1)\widehat{\sigma}_{\gamma_j}}{K - m}}
\deqn{\widehat{\sigma}_{\beta \gamma} = \frac{\sum_{j = 1}^{m} (k_j - 1)\widehat{\sigma}_{{\beta_j} {\gamma_j}}}{K - m}}
where \eqn{\widehat{\sigma}_{\beta_j}}, \eqn{\widehat{\sigma}_{\gamma_j}} and \eqn{\widehat{\sigma}_{{\beta_j} {\gamma_j}}} are the standard devations and covariance of \eqn{\beta} and \eqn{\gamma} parameters in the \eqn{j}th population.
}
\note{
These tests should only be performed on independent samples. If the acrophases of two populations are significantly different, the results of the amplitude difference test are not reliable and should not be interpreted. While it's possible to perform tests which compare more than two populations, this function can only compare two populations.
}
\examples{
fit.extraverts<-population.cosinor.lm(data = PA_extraverts, time = PA_time,
period = 24)
fit.introverts<-population.cosinor.lm(data = PA_introverts, time = PA_time,
period = 24)
cosinor.poptests(pop1 = fit.extraverts, pop2 = fit.introverts)
}
\references{
Bingham, C., Arbogast, B., Guillaume Cornélissen, G., Lee, J.K. & Halberg, F. (1982). Inferential Statistical Methods for Estimating and Comparing Cosinor Parameters. \emph{Chronobiologia}, \emph{9(4)}, 397-439.
}
