% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlevar.R
\name{per.snp.priors}
\alias{per.snp.priors}
\title{per.snp.priors}
\usage{
per.snp.priors(
  nsnps,
  pa = 3.82e-05,
  pc = 0.00182,
  p1 = NULL,
  p2 = NULL,
  p12 = NULL
)
}
\arguments{
\item{nsnps}{number of SNPs}

\item{pa}{prior probability that a non-query variant is causally associated with the query trait (cophescan prior), default 3.82e-5}

\item{pc}{prior probability that the query variant is causally associated with the query trait (cophescan prior), default 1.82e-3 (cophescan prior)}

\item{p1}{prior probability a SNP is associated with trait 1, (coloc prior), pc derived by using \eqn{pc =  p12/p1+p12}; use p1, p2, p12 only when pa and pc are unavailable (See vignettes)}

\item{p2}{prior probability a SNP is associated with trait 2,  (coloc prior), pa derived by using \eqn{pa = p2}}

\item{p12}{prior probability a SNP is associated with both traits,  (coloc prior), pc derived by using \eqn{pc =  p12/p1+p12}}
}
\value{
priors at the query variant
}
\description{
Estimate per snp priors
}
\author{
Ichcha Manipur
}
