% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convoSPAT_fitpred.R
\name{Aniso_pred}
\alias{Aniso_pred}
\title{Obtain predictions at unobserved locations for the stationary
spatial model.}
\usage{
Aniso_pred(Aniso.fit.obj, pred.coords, pred.covariates = NULL)
}
\arguments{
\item{Aniso.fit.obj}{Object from calling \code{Aniso_fit}.}

\item{pred.coords}{Matrix of locations where predictions are required.}

\item{pred.covariates}{Matrix of covariates for the prediction locations,
NOT including an intercept. The number of columns for this matrix must
match the design matrix from \code{mean.model} in \code{\link{NSconvo_fit}}.
Defaults to an intercept only.}
}
\value{
A list with the following components:
\item{pred.means}{Vector of the kriging predictor, for each location in
\code{pred.coords}.}
\item{pred.SDs}{Vector of the kriging standard errors, for each location
in \code{pred.coords}.}
}
\description{
\code{Aniso_pred} calculates the kriging predictor and corresponding
standard errors at unmonitored sites.
}
\examples{
\dontrun{
pred.S <- Aniso_pred( Aniso.fit.obj = aniso.fit,
pred.coords = cbind(runif(300),runif(300)) )
}
}

