% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyfgt.R
\name{svyfgt}
\alias{svyfgt}
\alias{svyfgt.survey.design}
\alias{svyfgt.svyrep.design}
\alias{svyfgt.DBIsvydesign}
\title{FGT measure of poverty}
\usage{
svyfgt(formula, design, ...)

\method{svyfgt}{survey.design}(
  formula,
  design,
  g,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 0.6,
  quantiles = 0.5,
  na.rm = FALSE,
  thresh = FALSE,
  ...
)

\method{svyfgt}{svyrep.design}(
  formula,
  design,
  g,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 0.6,
  quantiles = 0.5,
  na.rm = FALSE,
  thresh = FALSE,
  ...
)

\method{svyfgt}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{passed to \code{svyarpr} and \code{svyarpt}}

\item{g}{If g=0 estimates the headcount ratio; If g=1 estimates the average normalised poverty gap, and if g=2 estimates the average squared normalised poverty gap}

\item{type_thresh}{type of poverty threshold. If "abs" the threshold is fixed and given the value
of abs_thresh; if "relq" it is given by percent times the quantile; if "relm" it is percent times the mean.}

\item{abs_thresh}{poverty threshold value if type_thresh is "abs"}

\item{percent}{the multiple of the the quantile or mean used in the poverty threshold definition}

\item{quantiles}{the quantile used used in the poverty threshold definition}

\item{na.rm}{Should cases with missing values be dropped?}

\item{thresh}{return the poverty threshold value}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the FGT measure for the cases: \code{alpha=0} headcount ratio and \code{alpha=1} poverty gap index.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\examples{
library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design

des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep( des_eusilc_rep )

# headcount ratio, poverty threshold fixed
svyfgt(~eqincome, des_eusilc, g=0,  abs_thresh=10000)
# poverty gap index, poverty threshold fixed
svyfgt(~eqincome, des_eusilc, g=1,  abs_thresh=10000)
# headcount ratio, poverty threshold equal to arpt
svyfgt(~eqincome, des_eusilc, g=0, type_thresh= "relq" , thresh = TRUE)
# poverty gap index, poverty threshold equal to arpt
svyfgt(~eqincome, des_eusilc, g=1, type_thresh= "relq", thresh = TRUE)
# headcount ratio, poverty threshold equal to .6 times the mean
svyfgt(~eqincome, des_eusilc, g=0, type_thresh= "relm", thresh = TRUE)
# poverty gap index, poverty threshold equal to 0.6 times the mean
svyfgt(~eqincome, des_eusilc, g=1, type_thresh= "relm" , thresh = TRUE)

#  using svrep.design:
# headcount ratio, poverty threshold fixed
svyfgt(~eqincome, des_eusilc_rep, g=0,  abs_thresh=10000)
# poverty gap index, poverty threshold fixed
svyfgt(~eqincome, des_eusilc, g=1,  abs_thresh=10000)
# headcount ratio, poverty threshold equal to arpt
svyfgt(~eqincome, des_eusilc_rep, g=0, type_thresh= "relq" , thresh = TRUE)
# poverty gap index, poverty threshold equal to arpt
svyfgt(~eqincome, des_eusilc, g=1, type_thresh= "relq", thresh = TRUE)
# headcount ratio, poverty threshold equal to .6 times the mean
svyfgt(~eqincome, des_eusilc_rep, g=0, type_thresh= "relm" , thresh = TRUE)
# poverty gap index, poverty threshold equal to 0.6 times the mean
svyfgt(~eqincome, des_eusilc_rep, g=1, type_thresh= "relm", thresh = TRUE)

\dontrun{

# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)


dbd_eusilc <- convey_prep( dbd_eusilc )

# headcount ratio, poverty threshold fixed
svyfgt(~eqincome, dbd_eusilc, g=0, abs_thresh=10000)
# poverty gap index, poverty threshold fixed
svyfgt(~eqincome, dbd_eusilc, g=1, abs_thresh=10000)
# headcount ratio, poverty threshold equal to arpt
svyfgt(~eqincome, dbd_eusilc, g=0, type_thresh= "relq", thresh = TRUE)
# poverty gap index, poverty threshold equal to arpt
svyfgt(~eqincome, dbd_eusilc, g=1, type_thresh= "relq")
# headcount ratio, poverty threshold equal to .6 times the mean
svyfgt(~eqincome, dbd_eusilc, g=0, type_thresh= "relm")
# poverty gap index, poverty threshold equal to 0.6 times the mean
svyfgt(~eqincome, dbd_eusilc, g=1, type_thresh= "relm")

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
James Foster, Joel Greer and Erik Thorbecke (1984). A class of decomposable poverty measures.
\emph{Econometrica}, Vol.52, No.3, pp. 761-766.

Guillaume Osier (2009). Variance estimation for complex indicators
of poverty and inequality. \emph{Journal of the European Survey Research
Association}, Vol.3, No.3, pp. 167-195,
ISSN 1864-3361, URL \url{http://ojs.ub.uni-konstanz.de/srm/article/view/369}.

Jean-Claude Deville (1999). Variance estimation for complex statistics and estimators:
linearization and residual techniques. Survey Methodology, 25, 193-203,
URL \url{http://www5.statcan.gc.ca/bsolc/olc-cel/olc-cel?lang=eng&catno=12-001-X19990024882}.
}
\seealso{
\code{\link{svyarpt}}
}
\author{
Djalma Pessoa and Anthony Damico
}
\keyword{survey}
