% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyrmir.R
\name{svyrmir}
\alias{svyrmir}
\alias{svyrmir.DBIsvydesign}
\alias{svyrmir.survey.design}
\alias{svyrmir.svyrep.design}
\title{Relative median income ratio}
\usage{
svyrmir(formula, design, ...)

\method{svyrmir}{survey.design}(formula, design, age, agelim = 65,
  order = 0.5, na.rm = FALSE, med_old = FALSE, med_young = FALSE, ...)

\method{svyrmir}{svyrep.design}(formula, design, age, agelim = 65,
  order = 0.5, na.rm = FALSE, med_old = FALSE, med_young = FALSE, ...)

\method{svyrmir}{DBIsvydesign}(formula, design, age, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{age}{formula defining the variable age}

\item{agelim}{the age cutpoint, the default is 65}

\item{order}{income quantile order, usually .5}

\item{na.rm}{Should cases with missing values be dropped?}

\item{med_old}{return the median income of people older than agelim}

\item{med_young}{return the median income of people younger than agelim}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the ratio between the median income of people with age above 65 and the median income of people with age below 65.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\examples{
library(survey)
library(vardpoor)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# missing completely at random, missingness rate = .20
ind_miss <- rbinom(nrow(eusilc), 1, .20 )
eusilc$eqincome_miss <- eusilc$eqincome
is.na(eusilc$eqincome_miss)<- ind_miss==1

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep(des_eusilc)

svyrmir( ~eqincome , design = des_eusilc , age = ~age, med_old = TRUE )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep(des_eusilc_rep)

svyrmir( ~eqincome , design = des_eusilc_rep, age= ~age, med_old = TRUE )

# linearized design using a variable with missings
svyrmir( ~ eqincome_miss , design = des_eusilc,age= ~age)
svyrmir( ~ eqincome_miss , design = des_eusilc , age= ~age, na.rm = TRUE )
# replicate-weighted design using a variable with missings
svyrmir( ~ eqincome_miss , design = des_eusilc_rep,age= ~age )
svyrmir( ~ eqincome_miss , design = des_eusilc_rep ,age= ~age, na.rm = TRUE )


# library(MonetDBLite) is only available on 64-bit machines,
# so do not run this block of code in 32-bit R
\dontrun{

# database-backed design
library(MonetDBLite)
library(DBI)
dbfolder <- tempdir()
conn <- dbConnect( MonetDBLite::MonetDBLite() , dbfolder )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 , 
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfolder,
		dbtype="MonetDBLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )

svyrmir( ~eqincome , design = dbd_eusilc , age = ~age )

dbRemoveTable( conn , 'eusilc' )

}

}
\author{
Djalma Pessoa and Anthony Damico
}
\references{
Guillaume Osier (2009). Variance estimation for complex indicators
of poverty and inequality. \emph{Journal of the European Survey Research
Association}, Vol.3, No.3, pp. 167-195,
ISSN 1864-3361, URL \url{http://ojs.ub.uni-konstanz.de/srm/article/view/369}.

Jean-Claude Deville (1999). Variance estimation for complex statistics and estimators:
linearization and residual techniques. Survey Methodology, 25, 193-203,
URL \url{http://www5.statcan.gc.ca/bsolc/olc-cel/olc-cel?lang=eng&catno=12-001-X19990024882}.
}
\seealso{
\code{\link{svyarpt}}
}
\keyword{survey}

