% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Score_test_1x2.R
\name{Score_test_1x2}
\alias{Score_test_1x2}
\title{The score test for the binomial probability (pi)}
\usage{
Score_test_1x2(X, n, pi0)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{pi0}{a given probability}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The score test for the binomial probability (pi)
H_0: pi = pi0  vs  H_A: pi ~= pi0 (two-sided)
Described in Chapter 2 "The 1x2 Table and the Binomial Distribution"
}
\examples{
# The number of 1st order male births (Singh et al. 2010, adapted)
Score_test_1x2(singh_2010["1st", "X"], singh_2010["1st", "n"], pi0 = .5)
# The number of 2nd order male births (Singh et al. 2010, adapted)
Score_test_1x2(singh_2010["2nd", "X"], singh_2010["2nd", "n"], pi0 = .5)
# The number of 3rd order male births (Singh et al. 2010, adapted)
Score_test_1x2(singh_2010["3rd", "X"], singh_2010["3rd", "n"], pi0 = .5)
# The number of 4th order male births (Singh et al. 2010, adapted)
Score_test_1x2(singh_2010["4th", "X"], singh_2010["4th", "n"], pi0 = .5)
# Ligarden et al. (2010, adapted)
Score_test_1x2(ligarden_2010["X"], ligarden_2010["n"], pi0 = .5)
}
