% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClopperPearson_exact_CI_1x2_beta_version.R
\name{ClopperPearson_exact_CI_1x2_beta_version}
\alias{ClopperPearson_exact_CI_1x2_beta_version}
\title{The Clopper-Pearson exact confidence interval for the binomial probability (beta version)}
\usage{
ClopperPearson_exact_CI_1x2_beta_version(
  X,
  n,
  alpha = 0.05,
  printresults = TRUE
)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95# CIs}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing lower, upper and point estimates of the statistic
}
\description{
The Clopper-Pearson exact confidence interval for the binomial probability

(defined via the beta distribution)

Described in Chapter 2 "The 1x2 Table and the Binomial Distribution"
}
\examples{
# The number of 1st order male births (Singh et al. 2010)
ClopperPearson_exact_CI_1x2_beta_version(X = 250, n = 533)
# The number of 2nd order male births (Singh et al. 2010)
ClopperPearson_exact_CI_1x2_beta_version(X = 204, n = 412)
# The number of 3rd order male births (Singh et al. 2010)
ClopperPearson_exact_CI_1x2_beta_version(X = 103, n = 167)
# The number of 4th order male births (Singh et al. 2010)
ClopperPearson_exact_CI_1x2_beta_version(X = 33, n = 45)
# Ligarden et al. (2010)
ClopperPearson_exact_CI_1x2_beta_version(X = 13, n = 16)
}
\references{
Brown LD, Cai T, DasGupta A (2001) Interval estimation for a
binomial proportion. Statistical Science; 16:101-133
}
\seealso{
ClopperPearson_exact_CI_1x2
}
