% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-logical.R
\name{opts_logical}
\alias{opts_logical}
\title{Constructive options for type 'logical'}
\usage{
opts_logical(
  constructor = c("default"),
  ...,
  trim = NULL,
  fill = c("default", "rlang", "+", "...", "none"),
  compress = TRUE
)
}
\arguments{
\item{constructor}{String. Method used to construct the object, often the name
of a function.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}

\item{trim}{\code{NULL} or integerish. Maximum of elements showed before it's trimmed.
Note that it will necessarily produce code that doesn't reproduce the input.
This code will parse without failure but its evaluation might fail.}

\item{fill}{String. Method to use to represent the trimmed elements. See \code{?opts_atomic}}

\item{compress}{Boolean. If \code{TRUE} instead of \code{c()} Use \code{seq()}, \code{rep()}
when relevant to simplify the output.}
}
\value{
An object of class <constructive_options/constructive_options_logical>
}
\description{
These options will be used on objects of type 'logical'. This type has
a single native constructor, but some additional options can be set.

To set options on all atomic types at once see \link{opts_atomic}().
}
