% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_synthesize.R
\name{ms_synthesize}
\alias{ms_synthesize}
\title{Convert Text to Speech}
\usage{
ms_synthesize(
  script,
  region = "westus",
  api_key = NULL,
  token = NULL,
  gender = c("Female", "Male"),
  language = "en-US",
  voice = NULL,
  escape = FALSE
)
}
\arguments{
\item{script}{A character vector of text to be converted to speech}

\item{region}{Subscription region for API key. For more info, see
\url{https://learn.microsoft.com/en-us/azure/cognitive-services/speech-service/regions}}

\item{api_key}{Microsoft Azure Cognitive Services API key}

\item{token}{An authentication token}

\item{gender}{Sex of the speaker}

\item{language}{Language to be spoken}

\item{voice}{Full voice name}

\item{escape}{Should non-standard characters be substituted?}
}
\value{
An HTTP response in hexadecimal representation of binary data
}
\description{
Convert text to speech by using Speech Synthesis Markup Language (SSML)
}
\details{
For more info, see Section \href{https://learn.microsoft.com/en-us/azure/cognitive-services/Speech-Service/rest-text-to-speech?tabs=streaming#convert-text-to-speech}{Convert text to speech}
of the Microsoft documentation.
}
\examples{
\dontshow{if (ms_exist_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Convert text to speech
res <- ms_synthesize(script = "Hello world, this is a talking computer testing test",
                     region = "westus",
                     gender = "Female")
# Returns hexadecimal representation of binary data

# Create temporary file to store audio output
output_path <- tempfile(fileext = ".wav")
# Write binary data to output path
writeBin(res, con = output_path)
# Play audio in browser
# play_audio(audio = output_path)

# Delete temporary file
file.remove(output_path)
\dontshow{\}) # examplesIf}
}
