% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nextAlphaProb.R
\name{nextAlphaProb}
\alias{nextAlphaProb}
\title{Generate Next Alphabet}
\usage{
nextAlphaProb(alphaMatrix, currentAlpha, placement)
}
\arguments{
\item{alphaMatrix}{A table. This table is generated using the \code{\link{genMatrix}} function .}

\item{currentAlpha}{A string. This is the alphabet(s) for which the next alphabet is generated.}

\item{placement}{A string. This takes one of the two values namely "first" or "all".}
}
\value{
The next alphabet following the input alphabet(s) passed by the argument \emph{currentAlpha}.
}
\description{
Generates next alphabet based on prior probabilities.
}
\details{
The purpose of this function is to generate the next alphabet for a given alphabet(s). This function uses prior probabilities to generate the next alphabet. Although there are two types of input tables passed into the function by using the parameter \emph{alphaMatrix}, the process to generate the next alphabet remains the same as given below.

Firstly, the input table contains frequencies of the combination of current alphabet \emph{currentAlpha} (represented by rows) and next alphabet(represented by columns). These frequencies are converted into a percentage at a row level. This means that for each row, the sum of all the column values will add to 1.

Secondly, for the given \emph{currentAlpha}, the table is looked up for the corresponding column where the probability is the highest. The alphabet for the column with maximum prior probability is selected as the next alphabet and is returned by the function.
}
