% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_rsquared.R
\name{ci_rsquared}
\alias{ci_rsquared}
\title{CI for the Population R-Squared}
\usage{
ci_rsquared(x, df1 = NULL, df2 = NULL, probs = c(0.025, 0.975))
}
\arguments{
\item{x}{The result of \code{stats::lm()} or the F test statistic.}

\item{df1}{The numerator df. Only used if \code{x} is a test statistic.}

\item{df2}{The denominator df. Only used if \code{x} is a test statistic.}

\item{probs}{Lower and upper probabilities, by default c(0.025, 0.975).}
}
\value{
An object of class "cint" containing these components:
\itemize{
\item \code{parameter}: Parameter specification.
\item \code{interval}: CI for the parameter.
\item \code{estimate}: Parameter estimate.
\item \code{probs}: Lower and upper probabilities.
\item \code{type}: Type of interval.
\item \code{info}: Additional description.
}
}
\description{
This function calculates parametric CIs for the population R-squared.
It is based on CIs for the non-centrality parameter Delta of the F distribution,
found by test inversion. Delta values are mapped to R-squared by
R-squared = Delta / (Delta + df1 + df2 + 1), where df1 and df2 are the degrees
of freedom (df) of the F test statistic.
A positive lower (1-alpha)*100\%-confidence limit for the R-squared goes
hand-in-hand with a significant F test at level alpha.
}
\details{
According to \code{?stats::pf}, the results might be unreliable for very large F values.
Note that we do not provide bootstrap CIs here to keep the input interface simple.
}
\examples{
fit <- stats::lm(Sepal.Length ~ ., data = iris)
summary(fit)$r.squared
ci_rsquared(fit)
ci_rsquared(fit, probs = c(0.05, 1))
}
\references{
Smithson, M. (2003). Confidence intervals. Series: Quantitative Applications in the Social Sciences. New York, NY: Sage Publications.
}
\seealso{
\code{\link{ci_f_ncp}}.
}
