#' Parse the configuration {{var}} format, and replace it by extra.list values
#'
#' @param config A list that were generated by read.config/eval.config/eval.config.merge
#' @param extra.list A list that can replace the configuration file '{{debug}}' by list(debug = TRUE), and {{debug}} will be setted to TRUE
#' @param other.config Path of another configuration file that can replace the configuration file '{{key:value}}' 
#' @param rcmd.parse Logical wheather parse '@>@str_replace('abc', 'b', 'c')@<@' that existed in config to 'acc'
#' @return A list
#' @export
#' @examples
#' config.json <- system.file('extdata', 'config.json', package='configr')
#' config <- read.config(config.json)
#' parse.extra(config, list(debug = 'TRUE'))
parse.extra <- function(config, extra.list = list(), other.config = "", rcmd.parse = FALSE) {
  if (!is.null(names(extra.list))) {
    config <- parse.extra.list(config, extra.list)
  }
  if (other.config != "") {
    config <- parse.extra.config(config, other.config)
  }
  if (rcmd.parse) {
    config <- parse.extra.rcmd(config)
  }
  return(config)
}

# Parse the configuration {{var}} format string, and replace it by extra.list
# values
parse.extra.list <- function(config, extra.list) {
  list.names <- names(config)
  args.all <- extra.list
  for (list.item in list.names) {
    list.tmp <- config[[list.item]]
    if (is.list(list.tmp)) {
      config[[list.item]] <- parse.extra(config[[list.item]], args.all)
    } else {
      if (all(!str_detect(list.tmp, "\\{\\{"))) {
        next
      }
      text <- str.extract.var(list.tmp)
      for (item in text) {
        if (str_detect(item, ":")) {
          next
        }
        if (!item %in% names(args.all)) {
          next
        }
        item.value <- eval(parse(text = sprintf("args.all$`%s`", item)))
        config[[list.item]] <- str_replace_all(config[[list.item]], sprintf("\\{\\{%s\\}\\}", 
          item), item.value)
      }
    }
  }
  return(config)
}

# Parse the configuration {{key:value}} format string and replace it by
# other.config values
parse.extra.config <- function(config, other.config) {
  list.names <- names(config)
  if (!is.character(other.config)) {
    return(config)
  }
  for (list.item in list.names) {
    list.tmp <- config[[list.item]]
    if (is.list(list.tmp)) {
      config[[list.item]] <- parse.extra.config(config[[list.item]], other.config)
    } else {
      if (all(!str_detect(list.tmp, "\\{\\{"))) {
        next
      }
      text <- str.extract.var(list.tmp)
      if (length(text) == 0) {
        next
      }
      for (i in 1:length(text)) {
        if (is.list(text)) {
          text.nonlist <- text[[i]]
        } else {
          text.nonlist <- text
        }
        config <- parse.extra.config.nonlist(config, list.item, text.nonlist, 
          other.config)
      }
    }
  }
  return(config)
}

# Function read from other config and parse a key:value key2:value vector to real
# value
parse.extra.config.nonlist <- function(config, list.item, text.nonlist, other.config) {
  text <- text.nonlist
  other.config <- read.config(file = other.config)
  text.list <- str_split(text, ":")
  for (i in 1:length(text.list)) {
    pass <- FALSE
    text.list.value <- text.list[[i]]
    for (j in 1:length(text.list.value)) {
      if (j == 1) {
        if (text.list.value[[j]] %in% names(other.config)) {
          other.config.tmp <- other.config[[text.list.value[[j]]]]
        } else {
          other.config.tmp <- list()
          pass <- TRUE
        }
      } else {
        if (text.list.value[[j]] %in% names(other.config.tmp)) {
          other.config.tmp <- other.config.tmp[[text.list.value[[j]]]]
        } else {
          pass <- TRUE
        }
      }
    }
    if (!pass) {
      other.config.tmp <- as.character(other.config.tmp)
      config[[list.item]] <- str_replace_all(config[[list.item]], sprintf("\\{\\{%s\\}\\}", 
        text[i]), other.config.tmp)
    }
  }
  return(config)
}

# Parse the configuration @>@ Rcmd @<@ format string and replace it by its return
# values
parse.extra.rcmd <- function(config) {
  list.names <- names(config)
  for (list.item in list.names) {
    list.tmp <- config[[list.item]]
    if (is.list(list.tmp)) {
      config[[list.item]] <- parse.extra.rcmd(config[[list.item]])
    } else {
      if (all(!str_detect(list.tmp, "@>@") | !str_detect(list.tmp, "@<@"))) {
        next
      }
      text <- str_extract_all(list.tmp, "@>@.*@<@")
      text <- lapply(text, function(x) str_split(x, fixed("@<@")))
      text <- unlist(text)
      text <- text[text != ""]
      text <- paste0(text, "@<@")
      text <- str_replace_all(text, ".*@>@", "@>@")
      text <- str_replace_all(text, "@<@.*", "@<@")
      text <- unique(text)
      if (length(text) == 0) {
        next
      }
      for (i in 1:length(text)) {
        if (is.list(text)) {
          text.nonlist <- text[[i]]
        } else {
          text.nonlist <- text
        }
        config <- parse.extra.rcmd.nonlist(config, list.item, text.nonlist)
      }
    }
  }
  return(config)
}

parse.extra.rcmd.nonlist <- function(config, list.item, text.nonlist) {
  for (text.raw in text.nonlist) {
    text.cmd <- str_replace_all(text.raw, "@>@|@<@", "")
    text.cmd <- str_replace_all(text.cmd, "%'%", "\"")
    cmd.value <- eval(parse(text = text.cmd))
    config[[list.item]] <- str_replace_all(config[[list.item]], fixed(text.raw), 
      cmd.value)
  }
  return(config)
}

str.extract.var <- function(text) {
  text <- str_extract_all(text, "\\{\\{.*\\}\\}")
  text <- str_extract_all(text, "\\{\\{[@a-zA-Z0-9_.:]*\\}\\}")
  text <- lapply(text, function(x) str_replace_all(x, "\"", ""))
  text <- lapply(text, function(x) str_replace_all(x, fixed("{{"), ""))
  text <- lapply(text, function(x) str_split(x, fixed("}}")))
  text <- unlist(text)
  text <- text[text != ""]
  text <- unique(text)
}
