config.json <- system.file('extdata', 'config.json', package='configr')
config.yml <- system.file('extdata', 'config.yml', package='configr')
config.ini <- system.file('extdata', 'config.ini', package='configr')

flog.info("Debug:config.list.merge(list(a=c(123,123),b=c(4,5,6),list(c=c(2,3,4))))")
list.left <- list(a=c(123,123), b=c(4,5,6))
list.right <- list(c=c(2,3,4))
print(config.list.merge(list.left, list.right))

flog.info("Debug:eval.config.merge(file=config.json)")
print(eval.config.merge(config.json))
flog.info("Debug:eval.config.merge(file=config.yml)")
print(eval.config.merge(config.json))
flog.info("Debug:eval.config.merge(file=config.ini)")
print(eval.config.merge(config.ini))

flog.info("Debug:eval.config.merge(file=config.json, 'default')")
print(eval.config.merge(config.json, "default"))
flog.info("Debug:eval.config.merge(file=config.yml,' default')")
print(eval.config.merge(config.yml, "default"))
flog.info("Debug:eval.config.merge(file=config.ini, 'default')")
print(eval.config.merge(config.ini, "default"))

flog.info("Debug:eval.config.merge(file=config.json, c('default', 'comments'))")
print(eval.config.merge(config.json, c("default", "comments")))
flog.info("Debug:eval.config.merge(file=config.yml, c('default', 'comments'))")
print(eval.config.merge(config.yml, c("default", "comments")))
flog.info("Debug:eval.config.merge(file=config.ini, c('default', 'comments'))")
print(eval.config.merge(config.ini, c("default", "comments")))
