% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVpredict.R
\name{CVpredict}
\alias{CVpredict}
\alias{CVpredict.default}
\alias{CVpredict.lm}
\alias{CVpredict.glm}
\alias{CVpredict.lda}
\alias{CVpredict.qda}
\alias{CVpredict.nnet}
\alias{CVpredict.randomForest}
\alias{CVpredict.ranger}
\alias{CVpredict.rpart}
\alias{CVpredict.tree}
\alias{CVpredict.C5.0}
\alias{CVpredict.svm}
\alias{CVpredict.gbm}
\alias{CVpredict.loess}
\alias{CVpredict.ksvm}
\alias{CVpredict.glmnet}
\alias{CVpredict.cv.glmnet}
\alias{CVpredict.glmnet.formula}
\alias{CVpredict.cv.glmnet.formula}
\alias{CVpredict.keras.engine.training.Model}
\alias{CVpredict.kde}
\alias{CVpredict.densityMclust}
\alias{CVpredict.MclustDA}
\alias{CVpredict.MclustDR}
\alias{CVpredict.Mclust}
\alias{CVpredict.train}
\alias{CVpredict.bartMachine}
\alias{CVpredict.model_fit}
\alias{CVpredict.WrappedModel}
\alias{CVpredict.Learner}
\title{A predict generic function for condvis}
\usage{
CVpredict(
  fit,
  newdata,
  ...,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL,
  pinterval = NULL,
  pinterval_level = 0.95
)

\method{CVpredict}{default}(
  fit,
  newdata,
  ...,
  ptype = "pred",
  pthreshold = NULL,
  pinterval = NULL,
  pinterval_level = 0.95,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{lm}(
  fit,
  newdata,
  ...,
  ptype = "pred",
  pthreshold = NULL,
  pinterval = NULL,
  pinterval_level = 0.95,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{glm}(
  fit,
  ...,
  type = "response",
  ptype = "pred",
  pthreshold = NULL,
  pinterval = NULL,
  pinterval_level = 0.95,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{lda}(
  fit,
  ...,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{qda}(
  fit,
  ...,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{nnet}(
  fit,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{randomForest}(
  fit,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{ranger}(
  fit,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{rpart}(
  fit,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{tree}(
  fit,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{C5.0}(
  fit,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{svm}(
  fit,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{gbm}(
  fit,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  n.trees = fit$n.trees,
  ptrans = NULL
)

\method{CVpredict}{loess}(fit, newdata = NULL, ...)

\method{CVpredict}{ksvm}(
  fit,
  newdata,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{glmnet}(
  fit,
  newdata,
  ...,
  type = "response",
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL,
  s = NULL,
  makex = NULL
)

\method{CVpredict}{cv.glmnet}(
  fit,
  newdata,
  ...,
  type = "response",
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL,
  makex = NULL
)

\method{CVpredict}{glmnet.formula}(
  fit,
  newdata,
  ...,
  type = "response",
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL,
  s = NULL
)

\method{CVpredict}{cv.glmnet.formula}(
  fit,
  newdata,
  ...,
  type = "response",
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{keras.engine.training.Model}(
  fit,
  newdata,
  ...,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL,
  batch_size = 32,
  response = NULL,
  predictors = NULL
)

\method{CVpredict}{kde}(fit, newdata = fit$x, ..., scale = TRUE)

\method{CVpredict}{densityMclust}(
  fit,
  newdata = NULL,
  ...,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL,
  scale = TRUE
)

\method{CVpredict}{MclustDA}(
  fit,
  newdata,
  ...,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{MclustDR}(
  fit,
  newdata,
  ...,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{Mclust}(
  fit,
  newdata,
  ...,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{train}(
  fit,
  newdata,
  ...,
  type = "response",
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{bartMachine}(
  fit,
  newdata,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL
)

\method{CVpredict}{model_fit}(
  fit,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL,
  pinterval = NULL,
  pinterval_level = 0.95
)

\method{CVpredict}{WrappedModel}(
  fit,
  newdata,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL,
  pinterval = NULL,
  pinterval_level = 0.95
)

\method{CVpredict}{Learner}(
  fit,
  newdata,
  ...,
  type = NULL,
  ptype = "pred",
  pthreshold = NULL,
  ylevels = NULL,
  ptrans = NULL,
  pinterval = NULL,
  pinterval_level = 0.95
)
}
\arguments{
\item{fit}{A fitted model}

\item{newdata}{Where to calculate predictions.}

\item{...}{extra arguments to predict}

\item{ptype}{One of "pred","prob" or "probmatrix"}

\item{pthreshold}{Used for calculating classes from probs, in the two class case}

\item{ylevels}{The levels of the response, when it is a factor}

\item{ptrans}{A function to apply to the result}

\item{pinterval}{NULL, "confidence" or "prediction". Only for lm, parsnip, mlr(regression, confidence only)}

\item{pinterval_level}{Defaults to 0.95}

\item{type}{For some predict methods}

\item{n.trees}{Used by CVpredict.gbm, passed to predict}

\item{s}{Used by CVpredict.glmnet and CVpredict.cv.glmnet, passed to predict}

\item{makex}{Used by CVpredict.glmnet and CVpredict.cv.glmnet. A function to construct xmatrix for predict.}

\item{batch_size}{Used by CVpredict.keras.engine.training.Model, passed to predict}

\item{response}{Used by CVpredict.keras.engine.training.Model. Name of response (optional)}

\item{predictors}{Used by CVpredict.keras.engine.training.Model. Name of predictors}

\item{scale}{Used by CVpredict for densities. If TRUE (default) rescales the conditional density to integrate to 1.}
}
\value{
a vector of predictions, or a matrix when type is "probmatrix"
}
\description{
A predict generic function for condvis
}
\details{
This is a wrapper for predict used by condvis.
When the model response is numeric, the result is a vector of predictions.
When the model response is a factor the result depends on the value of ptype.
If ptype="pred", the result is a factor.
If also threshold is numeric, it is used to threshold a numeric prediction to construct the factor
when the factor has two levels.
For ptype="prob", the result is a vector of probabilities for the last factor level.
For ptype="probmatrix", the result is a matrix  of probabilities for each factor level.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: CVpredict method

\item \code{lm}: CVpredict method

\item \code{glm}: CVpredict method

\item \code{lda}: CVpredict method

\item \code{qda}: CVpredict method

\item \code{nnet}: CVpredict method

\item \code{randomForest}: CVpredict method

\item \code{ranger}: CVpredict method

\item \code{rpart}: CVpredict method

\item \code{tree}: CVpredict method

\item \code{C5.0}: CVpredict method

\item \code{svm}: CVpredict method

\item \code{gbm}: CVpredict method

\item \code{loess}: CVpredict method

\item \code{ksvm}: CVpredict method

\item \code{glmnet}: CVpredict method

\item \code{cv.glmnet}: CVpredict method

\item \code{glmnet.formula}: CVpredict method

\item \code{cv.glmnet.formula}: CVpredict method

\item \code{keras.engine.training.Model}: CVpredict method

\item \code{kde}: CVpredict method

\item \code{densityMclust}: CVpredict method

\item \code{MclustDA}: CVpredict method

\item \code{MclustDR}: CVpredict method

\item \code{Mclust}: CVpredict method

\item \code{train}: CVpredict method for caret

\item \code{bartMachine}: CVpredict method

\item \code{model_fit}: CVpredict method for parsnip

\item \code{WrappedModel}: CVpredict method for mlr

\item \code{Learner}: CVpredict method for mlr3
}}

\examples{
#Fit a model. 
f <- lm(Fertility~ ., data=swiss)
CVpredict(f)

#Fit a model with a factor response
swiss1 <- swiss
swiss1$Fertility <-  cut(swiss$Fertility, c(0,80,100))
levels(swiss1$Fertility)<- c("lo", "hi")
f <- glm(Fertility~ ., data=swiss1, family="binomial")
CVpredict(f) # by default gives a factor
CVpredict(f, ptype="prob") # gives prob of level hi
CVpredict(f, ptype="probmatrix") # gives prob of both levels
}
