% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotxc.R
\name{plotxc}
\alias{plotxc}
\title{Condition selector plot}
\usage{
plotxc(xc, xc.cond, name = NULL, select.colour = NULL, select.lwd = NULL,
  cex.axis = NULL, cex.lab = NULL, tck = NULL, select.cex = 1, ...)
}
\arguments{
\item{xc}{A numeric or factor vector, or a dataframe with two columns}

\item{xc.cond}{Same type as \code{xc}, representing a single point in data
space to highlight.}

\item{name}{The variable name for \code{xc}}

\item{select.colour}{Colour to highlight \code{xc.cond}}

\item{select.lwd}{Line weight to highlight \code{xc.cond}}

\item{cex.axis}{Axis text scaling}

\item{cex.lab}{Label text scaling}

\item{tck}{Plot axis tick size}

\item{select.cex}{Plot symbol size}

\item{...}{Passed to \code{condvis:::spineplot2}.}
}
\value{
Produces a plot, and returns a list containing the relevant
  information to update the plot at a later stage.
}
\description{
Data visualisations used to select sections for
  \code{\link{ceplot}}.
}
\examples{
## histogram, highlighting the first case
data(mtcars)
obj <- plotxc(mtcars[, "mpg"], mtcars[1, "mpg"])
obj$usr

## barplot, highlighting 'cyl' = 6
plotxc(as.factor(mtcars[, "cyl"]), 6, select.colour = "blue")

## scatterplot, highlighting case 25
plotxc(mtcars[, c("qsec", "wt")], mtcars[25, c("qsec", "wt")],
  select.colour = "blue", select.lwd = 1, lty = 3)

## boxplot, where 'xc' contains one factor, and one numeric
mtcars$carb <- as.factor(mtcars$carb)
plotxc(mtcars[, c("carb", "wt")], mtcars[25, c("carb", "wt")],
  select.colour = "red", select.lwd = 3)

## spineplot, where 'xc' contains two factors
mtcars$gear <- as.factor(mtcars$gear)
mtcars$cyl <- as.factor(mtcars$cyl)
plotxc(mtcars[, c("cyl", "gear")], mtcars[25, c("cyl", "gear")],
  select.colour = "red")
}
\seealso{
\code{\link{ceplot}},  \code{\link{plotxs}}.
}

