% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcUTCI.r
\name{calcUTCI}
\alias{calcUTCI}
\alias{calcutci}
\alias{utci}
\alias{UTCI}
\title{Universal Thermal Comfort Index (UTCI)}
\usage{
calcUTCI(ta, tr, vel, rh)
}
\arguments{
\item{ta}{a numeric value presenting air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{a numeric value presenting air velocity in [m/s]}

\item{rh}{a numeric value presenting relative humidity [\%]}
}
\value{
the \code{utciValue} value rounded to one decimal
}
\description{
Functions to calculate UTCI.
}
\details{
air temperature and mean radiant temperature should be in Degree C unit. Air velocity has to be in m/s unit and relative humidity has to be put in percentage value.
}
\examples{
calcUTCI(25, 25, 1.0, 50) # Returns 24.6
}
\references{
UTCI project page on http://www.utci.org/ 
Original code in Python by Tartarini & Schiavon (2020) <doi:10.1016/j.softx.2020.100578>
}
\seealso{
see also \code{\link{calcComfInd}}
}
\author{
Code implemented in to R by Shaomi Rahman. Further contribution by Marcel Schweiker.
}
