\name{coloc.abf.datasets}
\alias{coloc.abf.datasets}
\title{Bayesian colocalisation analysis using data.frames}
\usage{
  coloc.abf.datasets(df1, df2,
    snps = intersect(setdiff(colnames(df1), response1),
                     setdiff(colnames(df2), response2)),
    response1 = "Y", response2 = "Y", ...)
}
\arguments{
  \item{df1}{dataset 1}

  \item{df2}{dataset 2}

  \item{snps}{col.names for snps}

  \item{response1}{col.name for response in dataset 1}

  \item{response2}{col.name for response in dataset 2}

  \item{...}{parameters passed to \code{\link{coloc.abf}}}
}
\value{
  output of \code{\link{coloc.abf}}
}
\description{
  Bayesian colocalisation analysis using data.frames
}
\details{
  Converts genetic data to snpStats objects, generates p
  values via score tests, then runs \code{\link{coloc.abf}}
}
\author{
  Chris Wallace
}

