/*
 * Decompiled with CFR 0.152.
 */
package com.datanalytics.colbycol;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Random;

public class ColByCol {
    private char sep;
    private int skip;
    private int[] justRead;
    private String inFileName;
    private String[] outFileName;
    private Random generator;
    private double samplePct;

    public ColByCol(String inFileName, String outFileNames, int[] justRead, double samplePct, int skip, String sep) {
        this.inFileName = inFileName;
        this.outFileName = outFileNames.split(";");
        this.justRead = justRead;
        this.generator = new Random(19740819L);
        this.samplePct = samplePct;
        this.skip = skip;
        this.sep = sep.charAt(0);
    }

    public void execute(String workDir) throws IOException {
        String[] nextLine;
        boolean doSample;
        CSVReader reader = new CSVReader((Reader)new FileReader(this.inFileName), this.sep);
        BufferedWriter[] outFile = new BufferedWriter[this.outFileName.length];
        for (int i = 0; i < this.outFileName.length; ++i) {
            outFile[i] = new BufferedWriter(new FileWriter(new File(workDir, this.outFileName[i])));
        }
        int cont = 0;
        boolean bl = doSample = this.samplePct < 1.0;
        while ((nextLine = reader.readNext()) != null) {
            if (++cont <= this.skip || doSample && this.generator.nextDouble() > this.samplePct) continue;
            for (int i : this.justRead) {
                String token = nextLine[i].trim();
                if (token.equals("")) {
                    token = "NA";
                }
                outFile[i].write(token + "\n");
            }
        }
        reader.close();
        for (int i = 0; i < this.outFileName.length; ++i) {
            outFile[i].close();
        }
    }
}

