% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions.R
\name{distributions}
\alias{Bernoulli}
\alias{BetaBinomial}
\alias{Binomial}
\alias{NegBin}
\alias{Poisson}
\alias{ZIB}
\alias{ZIBB}
\alias{ZINB}
\alias{ZIP}
\alias{distributions}
\title{Wrappers to random number generators for use with coenocliner}
\usage{
NegBin(n, mu, alpha)

Poisson(n, mu)

Bernoulli(n, mu)

Binomial(n, mu, size)

BetaBinomial(n, mu, size, theta)

ZIP(n, mu, zprobs)

ZINB(n, mu, alpha, zprobs)

ZIB(n, mu, size, zprobs)

ZIBB(n, mu, size, theta, zprobs)
}
\arguments{
\item{n}{the number of random draws, equal to number of species times the number of gradient locations.}

\item{mu}{the mean or expectation of the distribution. For \code{Bernoulli}, \code{Binomial}, and \code{BetaBinomial()} this is the probability of occurrence as given by the response function.}

\item{alpha}{numeric; parameter for the negative binomial distribution.}

\item{size}{numeric; binomial denominator, the total number of individuals counted for example}

\item{theta}{numeric; a positive \emph{inverse} overdispersion parameter for the Beta-Binomial distribution. Low values give high overdispersion. The variance is  \code{size*mu*(1-mu)*(1+(size-1)/(theta+1))} (Bolker, 2008)}

\item{zprobs}{numeric; zero-inflation parameter giving the proportion of extraneous zeros. Must be in range \eqn{0 \dots 1}{0 to 1}.}
}
\value{
a vector of random draws from the stated distribution.
}
\description{
Wrappers to random number generators for use with coenocliner
}
\author{
Gavin L. Simpson
}
\references{
Bolker, B.M. (2008) \emph{Ecological Models and Data
in R.} Princeton University Press.
}
\keyword{distribution}

