% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4stuff.R
\docType{methods}
\name{plot,cd.fit-method}
\alias{plot,cd.fit-method}
\alias{plot}
\title{Plots the estimated survival function with an option to plot the posterior draws or bootstraps behind the fit}
\usage{
\S4method{plot}{cd.fit}(x, y, col.main = rgb(230, 85, 13, maxColorValue =
  255), col.samps = rgb(99, 99, 99, 10, maxColorValue = 255),
  plot.n.samps = 200, add = F, xlim = range(x@data), ...)
}
\arguments{
\item{x}{\code{cd.fit} or \code{cd.fit.mcmc} object}

\item{y}{unused}

\item{col.main}{color for plotting the main estimate}

\item{col.samps}{color for the samples (should include some alpha transparency)}

\item{plot.n.samps}{how many posterior or bootstrap samples do you want to plot?}

\item{add}{add to existing plot?}

\item{xlim}{xlim for plot, defaults to the range of the data slot in x}

\item{...}{other options to pass to plot}
}
\description{
Plots the estimated survival function with an option to plot the posterior draws or bootstraps behind the fit
}
