% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicklook.R
\name{quicklook}
\alias{quicklook}
\title{Create a quicklook of NetCDF data}
\usage{
quicklook(
  config,
  filelist,
  outpath = getwd(),
  jpeg_quality = 100,
  dpi = 150,
  iwidth = 1242,
  logo = TRUE,
  copyright = TRUE,
  bluemarble = FALSE,
  maxpixels = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{config}{filename of configuration file. This may include the directory
(character).}

\item{filelist}{list of NetCDF file to create plots from (character).}

\item{outpath}{directory in which to save the output files.
(character).}

\item{jpeg_quality}{jpeg quality for the image in percent, see \link[grDevices:png]{grDevices::jpeg()}}

\item{dpi}{resolution of the image in dots per inch, see \link[grDevices:png]{grDevices::jpeg()}}

\item{iwidth}{width of the resulting image in pixels, see \link[grDevices:png]{grDevices::jpeg()}}

\item{logo}{logical; should the cmsaf logo be added to the plot?}

\item{copyright}{logical; should the copyright text be added to the plot?}

\item{bluemarble}{logical; should the data be plotted onto a NASA bluemarble (only available for MSG/Seviri based data)?
Due to data size this option is not available for the cmsafvis package on CRAN. Please have a look at
our website https://www.cmsaf.eu/R_toolbox}

\item{maxpixels}{logical; use actual number of pixels or default (100000)}

\item{verbose}{logical; if TRUE, progress messages are shown}
}
\value{
A jpeg file with the same name as the original NetCDF file.
}
\description{
The function creates a plot of the variables in NetCDF file(s) specified in the config file.
Only NetCDF files that conform to the \href{https://www.cmsaf.eu/EN/Products/NamingConvention/Naming_Convention_node.html}{CM SAF naming convention} are supported.
}
\details{
This operator can be applied using a configuration file (quicklook_config.yml).
An example config file can be found in the extdata folder of this package. The following
parameters can be defined:
\itemize{
\item{logo: }{color / black}
\item{slot: }{numeric (e.g., 13)}
\item{invert_col: }{TRUE / FALSE}
\item{Dataset: }{character (e.g., ICDR Seviri Radiation)}
\item{limits: }{min: numeric; max: numeric}
\item{legend: }{TRUE / FALSE}
\item{colorscale: }{character (e.g., Viridis)}
\item{unit: }{character (e.g., Percent / '\%')}
\item{var_name: }{character (e.g., Percent / '\%')}
\item{bluemarble: }{TRUE / FALSE}
\item{mirror_data: }{TRUE / FALSE / NP / SP}
\item{scale_factor: }{numeric (e.g., 1)}
\item{smooth_factor: }{numeric (e.g., 1)}
\item{aux_file: } {path to optional aux-file, including CLAAS level 2 lon/ lat data}
\item{sysd: } {path to optional sysdata.rda file, which includes bluemarble data}
\item{remap: } {remap data to regular grid. TRUE / FALSE}
}
}
