% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{read_gmt}
\alias{read_gmt}
\title{Read a GMT file into a data frame}
\usage{
read_gmt(file, geneset_label = "celltype", gene_label = "gene")
}
\arguments{
\item{file}{A connection object or a character string (can be a URL).}

\item{geneset_label}{Column name for gene sets (first column of the GMT file) in the output data frame.}

\item{gene_label}{Column name for genes (variable columns of the GMT file) in the output data frame.}
}
\value{
A data frame with gene sets as the first column and genes as the second column (one gene per row).
}
\description{
Read a GMT file into a data frame
}
\examples{
gmt <- "http://software.broadinstitute.org/gsea/msigdb/supplemental/scsig.all.v1.0.symbols.gmt"
gmt_tbl <- read_gmt(gmt)
head(gmt_tbl)
}
