% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterfns.R
\name{get_clusters}
\alias{get_clusters}
\title{get_clusters}
\usage{
get_clusters(
  myData,
  k_clust = 3,
  n_bg = 0,
  quick = TRUE,
  EMseeds = 1:3,
  edgepmat = NULL,
  blacklist = NULL,
  bdepar = list(chi = 0.5, edgepf = 8),
  newallrelativeprobabs = NULL
)
}
\arguments{
\item{myData}{Data to be clustered}

\item{k_clust}{Number of clusters}

\item{n_bg}{Number of covariates}

\item{quick}{if TRUE, then the runtime is quick}

\item{EMseeds}{Seeds}

\item{edgepmat}{Matrix of penalized edges in the search space}

\item{blacklist}{Matrix of forbidden edges in the search space}

\item{bdepar}{Hyperparameters for structure learning (BDE score)}

\item{newallrelativeprobabs}{relative probability of cluster assignment of each sample}
}
\value{
a list containing the clusterMemberships and "assignprogress"
}
\description{
Network-based clustering
}
\examples{
\donttest{
# choose data
my_data <- BiDAG::Asia[1:2000,]
# learn clusters
cluster_results <- get_clusters(my_data)
# visualize the networks
library(ggplot2)
library(ggraph)
library(igraph)
library(ggpubr)
plot_clusters(cluster_results)
}
}
