/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.InvalidationBatch;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationBatchStaxUnmarshaller
implements Unmarshaller<InvalidationBatch, StaxUnmarshallerContext> {
    private static InvalidationBatchStaxUnmarshaller instance;

    @Override
    public InvalidationBatch unmarshall(StaxUnmarshallerContext context) throws Exception {
        InvalidationBatch invalidationBatch = new InvalidationBatch();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return invalidationBatch;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Path", targetDepth)) {
                    invalidationBatch.getPaths().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CallerReference", targetDepth)) continue;
                invalidationBatch.setCallerReference(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return invalidationBatch;
    }

    public static InvalidationBatchStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InvalidationBatchStaxUnmarshaller();
        }
        return instance;
    }
}

