/*
 * Decompiled with CFR 0.152.
 */
package ppe.ec2;

import com.amazonaws.services.ec2.model.InstanceType;
import java.io.Serializable;
import ppe.Constants;
import ppe.ec2.ParamsEc2;

public class NetworkSpec
implements Serializable {
    static final long serialVersionUID = Constants.SERIAL_VERSION_UID;
    public String networkName;
    public InstanceType instanceType;
    public String imageID;
    public int nInstances;
    public String keyName;
    public String securityGroupName;
    public boolean useSpotInstances;
    public double spotPrice;
    public String clusterGroupName;
    public boolean useCluster;
    public boolean disableHyperThreading;
    public String availabilityZone;

    public NetworkSpec(ParamsEc2 params) {
        this.networkName = params.networkName;
        this.instanceType = params.instanceType;
        this.availabilityZone = null;
        this.nInstances = params.nInstances;
        this.keyName = params.keyName;
        this.securityGroupName = params.securityGroup;
        this.useSpotInstances = params.useSpotInstances;
        this.spotPrice = params.spotPrice;
        this.clusterGroupName = params.clusterGroupName;
        this.useCluster = params.useCluster;
        this.disableHyperThreading = params.disableHyperthreading;
    }

    public NetworkSpec() {
    }

    public boolean isComplete() {
        return !(this.networkName == null || this.instanceType == null || this.imageID == null || this.nInstances <= 0 || this.keyName == null || this.useSpotInstances && Double.isNaN(this.spotPrice) || this.useCluster && this.clusterGroupName == null);
    }

    public String listMissingParams() {
        return "Missing params: " + (this.networkName == null ? "networkName " : "") + (this.instanceType == null ? "instanceType " : "") + (this.imageID == null ? "imageID " : "") + (this.nInstances <= 0 ? "nInstances " : "") + (this.keyName == null ? "keyNames " : "") + (!this.useSpotInstances || Double.isNaN(this.spotPrice) ? "spotPrice" : "") + (!this.useCluster || this.clusterGroupName == null ? "clusterGroupName" : "");
    }

    public NetworkSpec cloneSpec() {
        NetworkSpec c = new NetworkSpec();
        c.networkName = this.nns(this.networkName);
        c.instanceType = this.instanceType;
        c.nInstances = this.nInstances;
        c.keyName = this.nns(this.keyName);
        c.securityGroupName = this.nns(this.securityGroupName);
        c.useSpotInstances = this.useSpotInstances;
        c.spotPrice = this.spotPrice;
        c.clusterGroupName = this.nns(this.clusterGroupName);
        c.useCluster = this.useCluster;
        c.disableHyperThreading = this.disableHyperThreading;
        return c;
    }

    private String nns(String x) {
        if (x != null) {
            return new String(x);
        }
        return null;
    }
}

