% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sur_residual.R
\name{surrogate.residual}
\alias{surrogate.residual}
\title{Surrogate Residuals for Replciations of Spatial Ordinal Data}
\usage{
surrogate.residual(response, covar, location, seed = NULL, midalpha,
  beta, sigma2, phi, burn.in = 20, output = TRUE)
}
\arguments{
\item{response}{a matrix of observation (row: spatial site and column: subject).}

\item{covar}{regression (design) matrix, including intercepts.}

\item{location}{a matrix contains spatial location of sites within each subject.}

\item{seed}{seed input for simulation (default =\code{NULL}).
Parameter values:}

\item{midalpha}{cutoff for latent ordinal response.}

\item{beta}{regression coefficient  for \code{covar}.}

\item{sigma2}{\eqn{\sigma^2} for exponential covariance.}

\item{phi}{spatial correlation for exponential covariance.}

\item{burn.in}{burn-in length (i.e. declaring the initial sample).}

\item{output}{logical flag indicates whether printing out result (default: \code{TRUE}).}
}
\value{
\code{surrogate.residual} returns a (no. spatial site * no. subject) matrix contains
raw surrogate residuals with element corresponds to the response matrix.
}
\description{
\code{surrogate.residual} simulate the surrogate residual with the the given parameter value and covariate for model diagnostics.
}
\details{
Given vector of observed responses, the design matrix, spatial location for sites and parameter value, raw surrogate residuals are simulated using an efficient Gibbs sampling, which can be used for model diagnostics. When the fitted model is correct, the raw surrogate residuals among subjects should follow multivariate normal with mean 0 and covariance Sigma. If the model is correct, residual plot should be close to a null plot or random scatter. For example, it can be used to check the potential missing in covariate, non-linearity of covariate and outliers. In particular for the example below, the residual plot shows that linearity of Xi is adequate for the model.
}
\examples{
set.seed(1228)
n.subject <- 50
n.lat <- n.lon <- 10
n.site <- n.lat*n.lon

beta <- c(1,2,-1) # First 1 here is the intercept
midalpha <- c(1.15, 2.18) ; phi <- 0.6 ; sigma2 <- 0.7

true <- c(midalpha,beta,phi,sigma2)

Xi <- rnorm(n.subject,0,1) ; Xj <- rbinom(n.site,1,0.6)

 VV <- matrix(NA, nrow = n.subject*n.site, ncol = 3)

 for(i in 1:n.subject){ for(j in 1:n.site){
     VV[(i-1)*n.site+j,] <- c(1,Xi[i],Xj[j])
       }
 }

location <- cbind(rep(seq(1,n.lat,length=n.lat),n.lat),rep(1:n.lon, each=n.lon))
response <- sim.rord(n.subject, n.site, n.rep = 1,
midalpha, beta, phi, sigma2, covar=VV, location)[[1]]

\dontrun{
# Example for linearity of covariate
sur.resid <- surrogate.residual(response, covar=VV, location, seed =1,
midalpha, beta, sigma2, phi,
burn.in=20, output = TRUE)

scatter.smooth(rep(Xi,each=n.site),c(sur.resid),
main="Surrogate residual against Xi", xlab="Xi", ylab="Surrogate residual",
lpars = list(col = "red", lwd = 3, lty = 2))

abline(h=0, col="blue")
}

}
