% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-year-week-day.R
\name{iso_year_week_day}
\alias{iso_year_week_day}
\title{Calendar: iso-year-week-day}
\usage{
iso_year_week_day(
  year,
  week = NULL,
  day = NULL,
  hour = NULL,
  minute = NULL,
  second = NULL,
  subsecond = NULL,
  ...,
  subsecond_precision = NULL
)
}
\arguments{
\item{year}{\verb{[integer]}

The ISO year. Values \verb{[-32767, 32767]} are generally allowed.}

\item{week}{\verb{[integer / "last" / NULL]}

The ISO week. Values \verb{[1, 53]} are allowed.

If \code{"last"}, then the last week of the ISO year is returned.}

\item{day}{\verb{[integer / NULL]}

The day of the week. Values \verb{[1, 7]} are allowed, with 1 = Monday
and 7 = Sunday, in accordance with the ISO specifications.}

\item{hour}{\verb{[integer / NULL]}

The hour. Values \verb{[0, 23]} are allowed.}

\item{minute}{\verb{[integer / NULL]}

The minute. Values \verb{[0, 59]} are allowed.}

\item{second}{\verb{[integer / NULL]}

The second. Values \verb{[0, 59]} are allowed.}

\item{subsecond}{\verb{[integer / NULL]}

The subsecond. If specified, \code{subsecond_precision} must also be specified
to determine how to interpret the \code{subsecond}.

If using milliseconds, values \verb{[0, 999]} are allowed.

If using microseconds, values \verb{[0, 999999]} are allowed.

If using nanoseconds, values \verb{[0, 999999999]} are allowed.}

\item{...}{These dots are for future extensions and must be empty.}

\item{subsecond_precision}{\verb{[character(1) / NULL]}

The precision to interpret \code{subsecond} as. One of: \code{"millisecond"},
\code{"microsecond"}, or \code{"nanosecond"}.}
}
\value{
A iso-year-week-day calendar vector.
}
\description{
\code{iso_year_week_day()} constructs a calendar from the ISO year, week number,
and week day.
}
\details{
Fields are recycled against each other.

Fields are collected in order until the first \code{NULL} field is located. No
fields after the first \code{NULL} field are used.
}
\examples{
# Year-week
x <- iso_year_week_day(2019:2025, 1)
x

# 2nd day of the first ISO week in multiple years
iso_days <- set_day(x, clock_iso_weekdays$tuesday)
iso_days

# What year-month-day is this?
as_year_month_day(iso_days)
}
