% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plothist.R
\name{plothist}
\alias{plothist}
\title{Create a histogram of deltaAICc values}
\usage{
plothist(dataset, datasetrand = NULL, histq = 0.99)
}
\arguments{
\item{dataset}{A dataframe containing information on all fitted climate
windows. Output from \code{\link{climatewin}}.}

\item{datasetrand}{A dataframe containing information on all fitted climate
windows using randomised data. Output from \code{\link{randwin}}.}

\item{histq}{If datasetrand is provided. The quantile of the randomised data
that will be compared to non-randomised data. Used to determine the
likelihood of finding a climate window model of a given deltaAICc value at
random.}
}
\value{
If datasetrand is provided, plothist will return two stacked histograms
 to compare the deltaAICc of non-randomised and randomised data. This can
 help determine the likelihood of obtaining a deltaAICc value of fitted
 climate windows at random. Without datasetrand, plotall will create a single
 histogram of deltaAICc values for all fitted climate windows.
}
\description{
Create a histogram of deltaAICc values for all fitted climate windows. Compare
with randomised data if provided.
}
\examples{
# Plot real and randomised data for the Mass dataset

data(MassOutput)
data(MassRand)

plothist(dataset = MassOutput, datasetrand = MassRand, histq = 0.95)

# Plot deltaAICc when no randomised data is provided

data(MassOutput)

plothist(dataset = MassOutput)
}
\author{
Liam D. Bailey and Martijn van de Pol
}

