% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/crosswin.R
\name{crosswin}
\alias{crosswin}
\title{Test the correlation between two climate variables}
\usage{
crosswin(xvar, xvar2, cdate, bdate, furthest, closest, stat, stat2, type,
  cutoff.day, cutoff.month, cinterval = "day", cmissing = FALSE)
}
\arguments{
\item{xvar}{The first climate variable of interest. Please specify the parent
environment and variable name (e.g. Climate$Temp).}

\item{xvar2}{The second climate variable of interest. Please specify the parent
environment and variable name (e.g. Climate$Temp).}

\item{cdate}{The climate date variable (dd/mm/yyyy). Please specify the parent
environment and variable name (e.g. Climate$Date).}

\item{bdate}{The biological date variable (dd/mm/yyyy). Please specify the
parent environment and variable name (e.g. Biol$Date).}

\item{furthest}{The furthest number of time intervals (set by cinterval) back
from the cutoff date or biological record that will be included in the
climate window search.}

\item{closest}{The closest number of time intervals (set by cinterval) back
from the cutoff date or biological record that will be included in the
climate window search.}

\item{stat}{The aggregate statistic used to analyse the climate data. Can
currently use basic R statistics (e.g. mean, min), as well as slope.
Additional aggregate statistics can be created using the format function(x)
(...). See FUN in \code{\link{apply}} for more detail.}

\item{stat2}{Second aggregate statistic used to analyse climate data (xvar2). Can
currently use basic R statistics (e.g. mean, min), as well as slope.
Additional aggregate statistics can be created using the format function(x)
(...). See FUN in \code{\link{apply}} for more detail.}

\item{type}{fixed or variable, whether you wish the climate window to be variable
(i.e. the number of days before each biological record is measured) or fixed
(i.e. number of days before a set point in time).}

\item{cutoff.day,cutoff.month}{If type is "fixed", the day and month of the year
from which the fixed window analysis will start.}

\item{cinterval}{The resolution at which climate window analysis will be
conducted. May be days ("day"), weeks ("week"), or months ("month"). Note the units
of parameters 'furthest' and 'closest' will differ depending on the choice
of cinterval}

\item{cmissing}{TRUE or FALSE, determines what should be done if there are
missing climate data. If FALSE, the function will not run if missing climate
data is encountered. If TRUE, any records affected by missing climate data
will be removed from climate window analysis.}
}
\value{
Will return a dataframe containing the correlation between the two
 climate variables.
}
\description{
Test the correlation between two climate variables across all considered climate
windows.
}
\examples{
\dontrun{
# Test correlation between temperature and rainfall in the MassClimate dataset.

data(Mass)
data(MassClimate)

cross <- crosswin(xvar = list(Temp = MassClimate$Temp),
                 xvar2 = list(Rain = MassClimate$Rain),
                 cdate = MassClimate$Date, bdate = Mass$Date,
                 furthest = 365, closest = 0,
                 stat = "mean", stat2 = "mean", type = "variable",
                 cmissing = FALSE, cinterval = "day")

# View the output
head(cross)

# Plot the output
plotcor(cross, type = "C")

}
}
\author{
Liam D. Bailey and Martijn van de Pol
}

