% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/climdex.r
\name{climdex.r20mm}
\alias{climdex.r20mm}
\title{Precipitation Exceeding 20mm Per Day}
\usage{
climdex.r20mm(ci)
}
\arguments{
\item{ci}{Object of type climdexInput.}
}
\value{
A vector containing the value of the index for each year.
}
\description{
This function computes the climdex index R20mm.
}
\details{
This function takes a climdexInput object as input and computes the climdex
index R20mm: the annual count of days where daily precipitation is more than 20mm per day.
}
\examples{
library(PCICt)

## Create a climdexInput object from some data already loaded in and
## ready to go.

## Parse the dates into PCICt.
tmax.dates <- as.PCICt(do.call(paste, ec.1018935.tmax[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
tmin.dates <- as.PCICt(do.call(paste, ec.1018935.tmin[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
prec.dates <- as.PCICt(do.call(paste, ec.1018935.prec[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")

## Load the data in.
ci <- climdexInput.raw(ec.1018935.tmax$MAX_TEMP,
ec.1018935.tmin$MIN_TEMP, ec.1018935.prec$ONE_DAY_PRECIPITATION,
tmax.dates, tmin.dates, prec.dates, base.range=c(1971, 2000))

## Create an annual timeseries of the R20mm index.
r20mm <- climdex.r20mm(ci)
}
\references{
\url{http://etccdi.pacificclimate.org/list_27_indices.shtml}
}
\seealso{
\code{\link{climdexInput.raw}}, \code{\link{climdexInput.csv}}.
}
\keyword{climate}
\keyword{ts}

