% Generated by roxygen2 (4.0.2): do not edit by hand
\name{print.ClickstreamClusters}
\alias{print.ClickstreamClusters}
\title{Prints a ClickstreamClusters object}
\usage{
\method{print}{ClickstreamClusters}(x, ...)
}
\arguments{
  \item{x}{A \code{ClickstreamClusters} object returned by
  \code{\link{clusterClickstreams}}.}

  \item{...}{Ignored parameters.}
}
\description{
Prints a \code{ClickstreamClusters} object. A
\code{ClickstreamClusters} object represents the result of
a cluster analysis on a list of clickstreams (see
\code{\link{clusterClickstreams}}).
}
\examples{
clickstreams<-c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
csf<-tempfile()
writeLines(clickstreams, csf)
cls<-readClickstreams(csf, header=TRUE)
clusters<-clusterClickstreams(cls, order=0, centers=2)
print(clusters)
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\seealso{
\code{\link{clusterClickstreams}},
\code{\link{summary.ClickstreamClusters}}
}

